/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.pipeline.modeldefinition.ast;

import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nonnull;
import net.sf.json.JSONArray;
import org.jenkinsci.plugins.pipeline.modeldefinition.ast.ModelASTElement;
import org.jenkinsci.plugins.pipeline.modeldefinition.ast.ModelASTStage;
import org.jenkinsci.plugins.pipeline.modeldefinition.validator.ModelValidator;

public final class ModelASTStages
extends ModelASTElement {
    private List<ModelASTStage> stages = new ArrayList<ModelASTStage>();
    private final UUID uuid = UUID.randomUUID();

    public ModelASTStages(Object sourceLocation) {
        super(sourceLocation);
    }

    public JSONArray toJSON() {
        JSONArray a = new JSONArray();
        for (ModelASTStage stage : this.stages) {
            a.add((Object)stage.toJSON());
        }
        return a;
    }

    @Override
    public void validate(@Nonnull ModelValidator validator) {
        this.validate(validator, false);
    }

    public void validate(ModelValidator validator, boolean isNested) {
        validator.validateElement(this);
        for (ModelASTStage stage : this.stages) {
            stage.validate(validator, isNested);
        }
    }

    @Override
    public String toGroovy() {
        StringBuilder result = new StringBuilder();
        for (ModelASTStage stage : this.stages) {
            result.append(stage.toGroovy());
        }
        return result.toString();
    }

    @Override
    public void removeSourceLocation() {
        super.removeSourceLocation();
        for (ModelASTStage stage : this.stages) {
            stage.removeSourceLocation();
        }
    }

    public UUID getUuid() {
        return this.uuid;
    }

    public List<ModelASTStage> getStages() {
        return this.stages;
    }

    public void setStages(List<ModelASTStage> stages) {
        this.stages = stages;
    }

    @Override
    public String toString() {
        return "ModelASTStages{stages=" + this.stages + "}";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ModelASTStages that = (ModelASTStages)o;
        return this.getStages() != null ? this.getStages().equals(that.getStages()) : that.getStages() == null;
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.getStages() != null ? this.getStages().hashCode() : 0);
        return result;
    }
}

