/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.pipeline.modeldefinition.config;

import com.cloudbees.hudson.plugins.folder.AbstractFolder;
import com.cloudbees.hudson.plugins.folder.AbstractFolderProperty;
import com.cloudbees.hudson.plugins.folder.AbstractFolderPropertyDescriptor;
import hudson.Extension;
import hudson.model.Item;
import hudson.model.ItemGroup;
import hudson.model.Job;
import hudson.model.Run;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;
import org.jenkinsci.Symbol;
import org.jenkinsci.plugins.docker.commons.credentials.DockerRegistryEndpoint;
import org.jenkinsci.plugins.pipeline.modeldefinition.Messages;
import org.jenkinsci.plugins.pipeline.modeldefinition.config.DockerPropertiesProvider;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;

public class FolderConfig
extends AbstractFolderProperty<AbstractFolder<?>> {
    private String dockerLabel;
    private DockerRegistryEndpoint registry;

    @DataBoundConstructor
    public FolderConfig() {
    }

    public FolderConfig(String dockerLabel, String url, String creds) {
        this.dockerLabel = dockerLabel;
        this.registry = new DockerRegistryEndpoint(url, creds);
    }

    public String getDockerLabel() {
        return this.dockerLabel;
    }

    @DataBoundSetter
    public void setDockerLabel(String dockerLabel) {
        this.dockerLabel = dockerLabel;
    }

    public DockerRegistryEndpoint getRegistry() {
        return this.registry;
    }

    @DataBoundSetter
    public void setRegistry(DockerRegistryEndpoint registry) {
        this.registry = registry;
    }

    @Extension(ordinal=10000.0)
    public static class FolderDockerPropertiesProvider
    extends DockerPropertiesProvider {
        @Override
        public String getLabel(@Nullable Run run) {
            if (run != null) {
                Job job = run.getParent();
                ItemGroup parent = job.getParent();
                while (parent != null) {
                    String label;
                    AbstractFolder folder;
                    FolderConfig config;
                    if (parent instanceof AbstractFolder && (config = (FolderConfig)(folder = (AbstractFolder)parent).getProperties().get(FolderConfig.class)) != null && !StringUtils.isBlank((String)(label = config.getDockerLabel()))) {
                        return label;
                    }
                    if (parent instanceof Item) {
                        parent = ((Item)parent).getParent();
                        continue;
                    }
                    parent = null;
                }
            }
            return null;
        }

        @Override
        public String getRegistryUrl(@Nullable Run run) {
            if (run != null) {
                Job job = run.getParent();
                ItemGroup parent = job.getParent();
                while (parent != null) {
                    DockerRegistryEndpoint registry;
                    AbstractFolder folder;
                    FolderConfig config;
                    if (parent instanceof AbstractFolder && (config = (FolderConfig)(folder = (AbstractFolder)parent).getProperties().get(FolderConfig.class)) != null && (registry = config.getRegistry()) != null && !StringUtils.isBlank((String)registry.getUrl())) {
                        return registry.getUrl();
                    }
                    if (parent instanceof Item) {
                        parent = ((Item)parent).getParent();
                        continue;
                    }
                    parent = null;
                }
            }
            return null;
        }

        @Override
        public String getRegistryCredentialsId(@Nullable Run run) {
            if (run != null) {
                Job job = run.getParent();
                ItemGroup parent = job.getParent();
                while (parent != null) {
                    DockerRegistryEndpoint registry;
                    AbstractFolder folder;
                    FolderConfig config;
                    if (parent instanceof AbstractFolder && (config = (FolderConfig)(folder = (AbstractFolder)parent).getProperties().get(FolderConfig.class)) != null && (registry = config.getRegistry()) != null && !StringUtils.isBlank((String)registry.getCredentialsId())) {
                        return registry.getCredentialsId();
                    }
                    if (parent instanceof Item) {
                        parent = ((Item)parent).getParent();
                        continue;
                    }
                    parent = null;
                }
            }
            return null;
        }
    }

    @Extension
    @Symbol(value={"pipeline-model"})
    public static class DescriptorImpl
    extends AbstractFolderPropertyDescriptor {
        @Nonnull
        public String getDisplayName() {
            return Messages.PipelineModelDefinition_DisplayName();
        }
    }
}

