/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.pipeline.modeldefinition.generator;

import hudson.Extension;
import hudson.model.Descriptor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import org.apache.commons.lang.StringUtils;
import org.jenkinsci.plugins.pipeline.modeldefinition.generator.AbstractDirective;
import org.jenkinsci.plugins.pipeline.modeldefinition.generator.DirectiveDescriptor;
import org.jenkinsci.plugins.workflow.cps.Snippetizer;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;

public class LibrariesDirective
extends AbstractDirective<LibrariesDirective> {
    private final List<NameAndVersion> libs = new ArrayList<NameAndVersion>();

    @DataBoundConstructor
    public LibrariesDirective(List<NameAndVersion> libs) {
        if (libs != null) {
            this.libs.addAll(libs);
        }
    }

    public List<NameAndVersion> getLibs() {
        return this.libs;
    }

    @Restricted(value={NoExternalUse.class})
    public static final class NameAndVersion {
        private String name;
        private String version;

        @DataBoundConstructor
        public NameAndVersion(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        @DataBoundSetter
        public void setVersion(String version) {
            this.version = version;
        }

        public String getVersion() {
            return this.version;
        }

        public String getLibString() {
            if (StringUtils.isEmpty((String)this.version)) {
                return this.name;
            }
            return this.name + "@" + this.version;
        }
    }

    @Extension
    public static class DescriptorImpl
    extends DirectiveDescriptor<LibrariesDirective> {
        @Override
        @Nonnull
        public String getName() {
            return "libraries";
        }

        @Override
        @Nonnull
        public String getDisplayName() {
            return "Shared Libraries";
        }

        @Override
        @Nonnull
        public List<Descriptor> getDescriptors() {
            return Collections.emptyList();
        }

        @Override
        @Nonnull
        public String toGroovy(@Nonnull LibrariesDirective directive) {
            StringBuilder result = new StringBuilder("libraries {\n");
            if (!directive.getLibs().isEmpty()) {
                for (NameAndVersion l : directive.getLibs()) {
                    result.append("lib(").append(Snippetizer.object2Groovy((Object)l.getLibString())).append(")\n");
                }
            } else {
                result.append("// No libraries specified\n");
            }
            result.append("}\n");
            return result.toString();
        }

        public String getLibHelp(String field) {
            return "/descriptor/" + this.getId() + "/help/" + field;
        }
    }
}

