/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.pipeline.modeldefinition.generator;

import hudson.Extension;
import hudson.ExtensionList;
import hudson.model.Descriptor;
import hudson.model.ParameterDefinition;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import org.jenkinsci.plugins.pipeline.modeldefinition.generator.AbstractDirective;
import org.jenkinsci.plugins.pipeline.modeldefinition.generator.DirectiveDescriptor;
import org.jenkinsci.plugins.structs.describable.UninstantiatedDescribable;
import org.jenkinsci.plugins.workflow.cps.Snippetizer;
import org.kohsuke.stapler.DataBoundConstructor;

public class ParametersDirective
extends AbstractDirective<ParametersDirective> {
    private List<ParameterDefinition> parameters = new ArrayList<ParameterDefinition>();

    @DataBoundConstructor
    public ParametersDirective(List<ParameterDefinition> parameters) {
        if (parameters != null) {
            this.parameters.addAll(parameters);
        }
    }

    @Nonnull
    public List<ParameterDefinition> getParameters() {
        return this.parameters;
    }

    @Extension
    public static class DescriptorImpl
    extends DirectiveDescriptor<ParametersDirective> {
        @Override
        @Nonnull
        public String getName() {
            return "parameters";
        }

        @Override
        @Nonnull
        public String getDisplayName() {
            return "Parameters";
        }

        @Override
        @Nonnull
        public List<Descriptor> getDescriptors() {
            return ExtensionList.lookup(ParameterDefinition.ParameterDescriptor.class).stream().filter(d -> DirectiveDescriptor.symbolForDescriptor((Descriptor)d) != null).sorted(Comparator.comparing(d -> DirectiveDescriptor.symbolForDescriptor((Descriptor)d))).collect(Collectors.toList());
        }

        @Override
        @Nonnull
        public String toGroovy(@Nonnull ParametersDirective directive) {
            StringBuilder result = new StringBuilder("parameters {\n");
            for (ParameterDefinition param : directive.parameters) {
                result.append(Snippetizer.object2Groovy((Object)UninstantiatedDescribable.from((Object)param)));
                result.append("\n");
            }
            result.append("}\n");
            return result.toString();
        }
    }
}

