/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.pipeline.modeldefinition.actions;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.Util;
import hudson.model.Action;
import hudson.model.Api;
import hudson.model.Cause;
import hudson.model.CauseAction;
import hudson.model.Failure;
import hudson.model.Item;
import hudson.model.Job;
import hudson.model.Queue;
import hudson.model.Run;
import hudson.util.FormValidation;
import hudson.util.HttpResponses;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import javax.servlet.ServletException;
import jenkins.model.Jenkins;
import jenkins.model.ParameterizedJobMixIn;
import jenkins.model.TransientActionFactory;
import net.sf.json.JSONObject;
import org.acegisecurity.AccessDeniedException;
import org.jenkinsci.plugins.pipeline.StageStatus;
import org.jenkinsci.plugins.pipeline.modeldefinition.Utils;
import org.jenkinsci.plugins.pipeline.modeldefinition.actions.ExecutionModelAction;
import org.jenkinsci.plugins.pipeline.modeldefinition.actions.Messages;
import org.jenkinsci.plugins.pipeline.modeldefinition.actions.RestartFlowFactoryAction;
import org.jenkinsci.plugins.pipeline.modeldefinition.ast.ModelASTStage;
import org.jenkinsci.plugins.pipeline.modeldefinition.causes.RestartDeclarativePipelineCause;
import org.jenkinsci.plugins.workflow.cps.CpsFlowExecution;
import org.jenkinsci.plugins.workflow.flow.FlowExecution;
import org.jenkinsci.plugins.workflow.flow.FlowExecutionOwner;
import org.jenkinsci.plugins.workflow.job.WorkflowRun;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.DoNotUse;
import org.kohsuke.accmod.restrictions.NoExternalUse;
import org.kohsuke.stapler.HttpResponse;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;
import org.kohsuke.stapler.export.Exported;
import org.kohsuke.stapler.export.ExportedBean;
import org.kohsuke.stapler.interceptor.RequirePOST;

@ExportedBean
public class RestartDeclarativePipelineAction
implements Action {
    private final Run run;

    private RestartDeclarativePipelineAction(Run run) {
        this.run = run;
    }

    public String getDisplayName() {
        return Messages.Restart_from_Stage();
    }

    public String getIconFileName() {
        return this.isRestartEnabled() ? "plugin/pipeline-model-definition/images/24x24/restart-stage.png" : null;
    }

    public String getUrlName() {
        return this.isRestartEnabled() ? "restart" : null;
    }

    public Run getOwner() {
        return this.run;
    }

    @CheckForNull
    private CpsFlowExecution getExecution() {
        FlowExecutionOwner owner = ((FlowExecutionOwner.Executable)this.run).asFlowExecutionOwner();
        if (owner == null) {
            return null;
        }
        FlowExecution exec = owner.getOrNull();
        return exec instanceof CpsFlowExecution ? (CpsFlowExecution)exec : null;
    }

    @Exported
    public boolean isRestartEnabled() {
        ExecutionModelAction executionModelAction = (ExecutionModelAction)this.run.getAction(ExecutionModelAction.class);
        return executionModelAction != null && !this.run.isBuilding() && this.run.hasPermission(Item.BUILD) && this.run.getParent().isBuildable() && this.getExecution() != null;
    }

    public Api getApi() {
        return new Api((Object)this);
    }

    @Restricted(value={NoExternalUse.class})
    @RequirePOST
    public HttpResponse doRestartPipeline(@QueryParameter String stageName) {
        HashMap<String, String> result = new HashMap<String, String>();
        result.put("success", "false");
        if (this.isRestartEnabled()) {
            try {
                this.run(stageName);
                result.put("success", "true");
                result.put("message", "ok");
            }
            catch (IllegalStateException ise) {
                result.put("message", "Failure restarting from stage: " + ise);
            }
        } else {
            result.put("message", "not allowed to restart");
        }
        return HttpResponses.okJSON(result);
    }

    @Restricted(value={DoNotUse.class})
    @RequirePOST
    public void doRestart(StaplerRequest req, StaplerResponse rsp) throws ServletException, IOException {
        if (!this.isRestartEnabled()) {
            throw new AccessDeniedException("not allowed to restart");
        }
        JSONObject form = req.getSubmittedForm();
        String stageName = Util.fixEmpty((String)form.getString("stageName"));
        try {
            this.run(stageName);
        }
        catch (IllegalStateException ise) {
            throw new Failure("Failure restarting from stage: " + ise);
        }
        rsp.sendRedirect("../..");
    }

    @Exported
    public List<String> getRestartableStages() {
        ExecutionModelAction execAction;
        ArrayList<String> stages = new ArrayList<String>();
        CpsFlowExecution execution = this.getExecution();
        if (execution != null && (execAction = (ExecutionModelAction)this.run.getAction(ExecutionModelAction.class)) != null && execAction.getStages() != null) {
            for (ModelASTStage s : execAction.getStages().getStages()) {
                if (Utils.stageHasStatusOf(s.getName(), (FlowExecution)execution, StageStatus.getSkippedForFailure(), StageStatus.getSkippedForUnstable())) continue;
                stages.add(s.getName());
            }
        }
        return stages;
    }

    public String getCheckUrl() {
        return Jenkins.get().getRootUrl() + this.run.getUrl() + this.getUrlName() + "/checkStageName";
    }

    public FormValidation doCheckStageName(@QueryParameter String value) {
        String s = Util.fixEmptyAndTrim((String)value);
        if (s == null || s.equals("")) {
            return FormValidation.error((String)Messages.RestartDeclarativePipelineAction_NullStageName());
        }
        if (!this.getRestartableStages().contains(s)) {
            return FormValidation.error((String)Messages.RestartDeclarativePipelineAction_StageNameNotPresent(s, this.run.getFullDisplayName()));
        }
        return FormValidation.ok();
    }

    public Queue.Item run(String stageName) {
        if (stageName == null || stageName.equals("")) {
            throw new IllegalStateException(Messages.RestartDeclarativePipelineAction_NullStageName());
        }
        if (!this.run.hasPermission(Item.BUILD) || !this.run.getParent().isBuildable()) {
            throw new IllegalStateException(Messages.RestartDeclarativePipelineAction_ProjectNotBuildable(this.run.getParent().getFullName()));
        }
        if (this.run.isBuilding()) {
            throw new IllegalStateException(Messages.RestartDeclarativePipelineAction_OriginRunIncomplete(this.run.getFullDisplayName()));
        }
        ExecutionModelAction execAction = (ExecutionModelAction)this.run.getAction(ExecutionModelAction.class);
        if (execAction == null) {
            throw new IllegalStateException(Messages.RestartDeclarativePipelineAction_OriginWasNotDeclarative(this.run.getFullDisplayName()));
        }
        if (!this.getRestartableStages().contains(stageName)) {
            throw new IllegalStateException(Messages.RestartDeclarativePipelineAction_StageNameNotPresent(stageName, this.run.getFullDisplayName()));
        }
        ArrayList<RestartFlowFactoryAction> actions = new ArrayList<RestartFlowFactoryAction>();
        CpsFlowExecution execution = this.getExecution();
        if (execution == null) {
            throw new IllegalStateException(Messages.RestartDeclarativePipelineAction_OriginRunMissingExecution(this.run.getFullDisplayName()));
        }
        actions.add(new RestartFlowFactoryAction(this.run.getExternalizableId()));
        actions.add((RestartFlowFactoryAction)new CauseAction(new Cause[]{new Cause.UserIdCause(), new RestartDeclarativePipelineCause(this.run, stageName)}));
        return ParameterizedJobMixIn.scheduleBuild2((Job)this.run.getParent(), (int)0, (Action[])actions.toArray(new Action[actions.size()]));
    }

    @Extension
    public static class Factory
    extends TransientActionFactory<WorkflowRun> {
        public Class<WorkflowRun> type() {
            return WorkflowRun.class;
        }

        @NonNull
        public Collection<? extends Action> createFor(@NonNull WorkflowRun run) {
            return Collections.singleton(new RestartDeclarativePipelineAction((Run)run));
        }
    }
}

