/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.pipeline.modeldefinition.agent.impl;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import hudson.Extension;
import hudson.Util;
import hudson.util.FormValidation;
import org.apache.commons.lang.StringUtils;
import org.jenkinsci.Symbol;
import org.jenkinsci.plugins.pipeline.modeldefinition.agent.DeclarativeAgent;
import org.jenkinsci.plugins.pipeline.modeldefinition.agent.DeclarativeAgentDescriptor;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.QueryParameter;

public class Label
extends DeclarativeAgent<Label> {
    private String label;
    private String customWorkspace;

    @DataBoundConstructor
    public Label(String label) {
        this.label = label;
    }

    @Nullable
    public String getLabel() {
        return this.label;
    }

    @CheckForNull
    public String getCustomWorkspace() {
        return this.customWorkspace;
    }

    @DataBoundSetter
    public void setCustomWorkspace(String customWorkspace) {
        this.customWorkspace = customWorkspace;
    }

    @Extension(ordinal=-800.0)
    @Symbol(value={"label", "node"})
    public static class DescriptorImpl
    extends DeclarativeAgentDescriptor<Label> {
        @NonNull
        public String getDisplayName() {
            return "Run on an agent matching a label";
        }

        public FormValidation doCheckLabel(@QueryParameter String label) {
            if (StringUtils.isEmpty((String)Util.fixEmptyAndTrim((String)label))) {
                return FormValidation.error((String)"Label is required.");
            }
            return FormValidation.ok();
        }
    }
}

