/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.pipeline.modeldefinition.actions;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import hudson.model.InvisibleAction;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jenkinsci.plugins.pipeline.modeldefinition.ast.ModelASTPipelineDef;
import org.jenkinsci.plugins.pipeline.modeldefinition.ast.ModelASTStages;

public class ExecutionModelAction
extends InvisibleAction {
    private String stagesUUID;
    private List<ModelASTPipelineDef> pipelineDefs = new ArrayList<ModelASTPipelineDef>();
    @Deprecated
    @CheckForNull
    private ModelASTStages stages;
    @Deprecated
    @CheckForNull
    private List<ModelASTStages> stagesList;

    public ExecutionModelAction(ModelASTPipelineDef pipeline) {
        this.pipelineDefs.add(pipeline);
    }

    @Deprecated
    public ExecutionModelAction(ModelASTStages s) {
        this(ExecutionModelAction.createDummyPipelineDef(s));
    }

    @Deprecated
    public ExecutionModelAction(List<ModelASTStages> stages) {
        for (ModelASTStages s : stages) {
            this.pipelineDefs.add(ExecutionModelAction.createDummyPipelineDef(s));
        }
    }

    protected Object readResolve() throws IOException {
        if (this.pipelineDefs == null) {
            this.pipelineDefs = new ArrayList<ModelASTPipelineDef>();
        }
        if (this.stages != null) {
            this.pipelineDefs.add(ExecutionModelAction.createDummyPipelineDef(this.stages));
            this.stages = null;
        } else if (this.stagesList != null) {
            for (ModelASTStages s : this.stagesList) {
                this.pipelineDefs.add(ExecutionModelAction.createDummyPipelineDef(s));
            }
            this.stagesList = null;
        }
        return this;
    }

    private static ModelASTPipelineDef createDummyPipelineDef(ModelASTStages s) {
        ModelASTPipelineDef dummyDef = new ModelASTPipelineDef(null);
        dummyDef.setStages(s);
        return dummyDef;
    }

    public ModelASTStages getStages() {
        for (ModelASTPipelineDef p : this.pipelineDefs) {
            ModelASTStages s = p.getStages();
            if (!s.getUuid().toString().equals(this.stagesUUID)) continue;
            return s;
        }
        return null;
    }

    public String getStagesUUID() {
        return this.stagesUUID;
    }

    public void setStagesUUID(String s) {
        this.stagesUUID = s;
    }

    public List<ModelASTStages> getStagesList() {
        ArrayList<ModelASTStages> stages = new ArrayList<ModelASTStages>();
        for (ModelASTPipelineDef p : this.pipelineDefs) {
            stages.add(p.getStages());
        }
        return Collections.unmodifiableList(stages);
    }

    @Deprecated
    public void addStages(ModelASTStages s) {
        ModelASTPipelineDef dummyDefForBackwardsCompat = new ModelASTPipelineDef(null);
        dummyDefForBackwardsCompat.setStages(s);
        this.pipelineDefs.add(dummyDefForBackwardsCompat);
    }

    public ModelASTPipelineDef getPipelineDef() {
        for (ModelASTPipelineDef p : this.pipelineDefs) {
            if (!p.getStages().getUuid().toString().equals(this.stagesUUID)) continue;
            return p;
        }
        return null;
    }

    public List<ModelASTPipelineDef> getPipelineDefs() {
        return Collections.unmodifiableList(this.pipelineDefs);
    }

    public void addPipelineDef(ModelASTPipelineDef p) {
        this.pipelineDefs.add(p);
    }
}

