/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.pipeline.modeldefinition.cli;

import hudson.Extension;
import hudson.cli.CLICommand;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import jenkins.model.Jenkins;
import org.apache.commons.io.IOUtils;
import org.jenkinsci.plugins.pipeline.modeldefinition.ast.ModelASTPipelineDef;
import org.jenkinsci.plugins.pipeline.modeldefinition.cli.Messages;
import org.jenkinsci.plugins.pipeline.modeldefinition.endpoints.ModelConverterAction;
import org.jenkinsci.plugins.pipeline.modeldefinition.parser.Converter;

@Extension
public class DeclarativeLinterCommand
extends CLICommand {
    public String getShortDescription() {
        return Messages.DeclarativeLinterCommand_ShortDescription();
    }

    protected int run() throws Exception {
        Jenkins.get().checkPermission(Jenkins.READ);
        int retVal = 0;
        ArrayList<Object> output = new ArrayList<Object>();
        String script = IOUtils.toString((InputStream)this.stdin);
        if (script != null) {
            try {
                ModelASTPipelineDef pipelineDef = Converter.scriptToPipelineDef(script);
                if (pipelineDef != null) {
                    output.add("Jenkinsfile successfully validated.");
                    retVal = 0;
                } else {
                    output.add("Jenkinsfile content '" + script + "' did not contain the 'pipeline' step");
                    retVal = 1;
                }
            }
            catch (Exception e) {
                output.add("Errors encountered validating Jenkinsfile:");
                retVal = 1;
                output.addAll(ModelConverterAction.errorToStrings(e));
            }
        }
        IOUtils.writeLines(output, null, (OutputStream)this.stdout);
        return retVal;
    }
}

