/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.pipeline.modeldefinition.generator;

import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.model.Descriptor;
import hudson.util.FormValidation;
import java.util.ArrayList;
import java.util.List;
import jenkins.model.Jenkins;
import org.apache.commons.lang.StringUtils;
import org.jenkinsci.plugins.pipeline.modeldefinition.generator.AbstractDirective;
import org.jenkinsci.plugins.pipeline.modeldefinition.generator.AgentDirective;
import org.jenkinsci.plugins.pipeline.modeldefinition.generator.DirectiveDescriptor;
import org.jenkinsci.plugins.pipeline.modeldefinition.generator.EnvironmentDirective;
import org.jenkinsci.plugins.pipeline.modeldefinition.generator.InputDirective;
import org.jenkinsci.plugins.pipeline.modeldefinition.generator.Messages;
import org.jenkinsci.plugins.pipeline.modeldefinition.generator.OptionsDirective;
import org.jenkinsci.plugins.pipeline.modeldefinition.generator.PostDirective;
import org.jenkinsci.plugins.pipeline.modeldefinition.generator.ToolsDirective;
import org.jenkinsci.plugins.pipeline.modeldefinition.generator.WhenDirective;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;

public class StageDirective
extends AbstractDirective<StageDirective> {
    private List<AbstractDirective> directives = new ArrayList<AbstractDirective>();
    private String name;
    private StageContentType contentType;

    @DataBoundConstructor
    public StageDirective(List<AbstractDirective> directives, @NonNull String name, StageContentType contentType) {
        if (directives != null) {
            this.directives.addAll(directives);
        }
        this.name = name;
        this.contentType = contentType;
    }

    @NonNull
    public String getName() {
        return this.name;
    }

    public StageContentType getContentType() {
        return this.contentType;
    }

    @NonNull
    public List<AbstractDirective> getDirectives() {
        return this.directives;
    }

    public static enum StageContentType {
        STEPS,
        PARALLEL,
        STAGES,
        MATRIX;


        public String getName() {
            if (this == STEPS) {
                return Messages.StageDirective_Steps_name();
            }
            if (this == PARALLEL) {
                return Messages.StageDirective_Parallel_name();
            }
            if (this == STAGES) {
                return Messages.StageDirective_Stages_name();
            }
            if (this == MATRIX) {
                return Messages.StageDirective_Matrix_name();
            }
            return "(unknown)";
        }
    }

    @Extension
    public static class DescriptorImpl
    extends DirectiveDescriptor<StageDirective> {
        @Override
        @NonNull
        public String getName() {
            return "stage";
        }

        @Override
        @NonNull
        public String getDisplayName() {
            return "Stage";
        }

        @Override
        @NonNull
        public List<Descriptor> getDescriptors() {
            ArrayList<Descriptor> descriptors = new ArrayList<Descriptor>();
            descriptors.add(Jenkins.get().getDescriptorByType(AgentDirective.DescriptorImpl.class));
            descriptors.add(Jenkins.get().getDescriptorByType(InputDirective.DescriptorImpl.class));
            descriptors.add(Jenkins.get().getDescriptorByType(EnvironmentDirective.DescriptorImpl.class));
            descriptors.add(Jenkins.get().getDescriptorByType(OptionsDirective.DescriptorImpl.class));
            descriptors.add(Jenkins.get().getDescriptorByType(WhenDirective.DescriptorImpl.class));
            descriptors.add(Jenkins.get().getDescriptorByType(ToolsDirective.DescriptorImpl.class));
            descriptors.add(Jenkins.get().getDescriptorByType(PostDirective.DescriptorImpl.class));
            return descriptors;
        }

        public FormValidation doCheckName(@QueryParameter String value) {
            if (StringUtils.isEmpty((String)value)) {
                return FormValidation.error((String)"Stage name must be provided.");
            }
            return FormValidation.ok();
        }

        @Override
        @NonNull
        public String toGroovy(@NonNull StageDirective directive) {
            StringBuilder result = new StringBuilder("stage(");
            result.append("'").append(directive.name).append("') {\n");
            switch (directive.contentType) {
                case STEPS: {
                    result.append("steps {\n");
                    result.append("// One or more steps need to be included within the steps block.\n");
                    result.append("}\n");
                    break;
                }
                case PARALLEL: {
                    result.append("parallel {\n");
                    result.append("// One or more stages need to be included within the parallel block.\n");
                    result.append("}\n");
                    break;
                }
                case STAGES: {
                    result.append("stages {\n");
                    result.append("// One or more stages need to be included within the stages block.\n");
                    result.append("}\n");
                    break;
                }
                case MATRIX: {
                    result.append("matrix {\n");
                    result.append("// matrix need to be included.\n");
                    result.append("}\n");
                    break;
                }
                default: {
                    result.append("// Unknown stage content - only steps and parallel currently available.\n");
                }
            }
            for (AbstractDirective d : directive.directives) {
                result.append("\n").append(d.toGroovy(false));
            }
            result.append("}\n");
            return result.toString();
        }
    }
}

