/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.pipeline.modeldefinition.when.impl;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import java.util.regex.Pattern;
import org.codehaus.groovy.ast.expr.Expression;
import org.jenkinsci.Symbol;
import org.jenkinsci.plugins.pipeline.modeldefinition.ast.ModelASTWhenContent;
import org.jenkinsci.plugins.pipeline.modeldefinition.parser.ASTParserUtils;
import org.jenkinsci.plugins.pipeline.modeldefinition.when.DeclarativeStageConditional;
import org.jenkinsci.plugins.pipeline.modeldefinition.when.DeclarativeStageConditionalDescriptor;
import org.jenkinsci.plugins.workflow.cps.GroovySourceFileAllowlist;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;
import org.kohsuke.stapler.DataBoundConstructor;

public class ChangeLogConditional
extends DeclarativeStageConditional<ChangeLogConditional> {
    private Pattern asPattern;
    private Pattern multiLinePattern;
    private String pattern;

    @DataBoundConstructor
    public ChangeLogConditional(String pattern) {
        this.pattern = pattern;
        this.asPattern = Pattern.compile(pattern);
        this.multiLinePattern = Pattern.compile(ChangeLogConditional.expandForMultiLine(pattern), 40);
    }

    public Pattern getAsPattern() {
        return this.asPattern;
    }

    public String getPattern() {
        return this.pattern;
    }

    public Pattern getMultiLinePattern() {
        return this.multiLinePattern;
    }

    @Restricted(value={NoExternalUse.class})
    public static String expandForMultiLine(String pattern) {
        return "(?m)(?s)^[^\\r\\n]*?" + pattern + "[^\\r\\n]*?$";
    }

    @Extension
    public static class ChangelogConditionalScriptAllowlist
    extends GroovySourceFileAllowlist {
        private final String scriptUrl = ChangeLogConditional.class.getResource("AbstractChangelogConditionalScript.groovy").toString();

        public boolean isAllowed(String groovyResourceUrl) {
            return groovyResourceUrl.equals(this.scriptUrl);
        }
    }

    @Extension
    @Symbol(value={"changelog"})
    public static class DescriptorImpl
    extends DeclarativeStageConditionalDescriptor<ChangeLogConditional> {
        @NonNull
        public String getDisplayName() {
            return "Execute the stage if a commit message in the changelog matches";
        }

        public Expression transformToRuntimeAST(@CheckForNull ModelASTWhenContent original) {
            return ASTParserUtils.transformWhenContentToRuntimeAST(original);
        }
    }
}

