/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.pipeline.modeldefinition.when.impl;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import java.util.List;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.jenkinsci.plugins.pipeline.modeldefinition.Messages;
import org.jenkinsci.plugins.pipeline.modeldefinition.ast.ModelASTArgumentList;
import org.jenkinsci.plugins.pipeline.modeldefinition.ast.ModelASTNamedArgumentList;
import org.jenkinsci.plugins.pipeline.modeldefinition.ast.ModelASTPositionalArgumentList;
import org.jenkinsci.plugins.pipeline.modeldefinition.ast.ModelASTSingleArgument;
import org.jenkinsci.plugins.pipeline.modeldefinition.ast.ModelASTValue;
import org.jenkinsci.plugins.pipeline.modeldefinition.ast.ModelASTWhenCondition;
import org.jenkinsci.plugins.pipeline.modeldefinition.validator.DeclarativeValidatorContributor;
import org.jenkinsci.plugins.pipeline.modeldefinition.when.impl.ChangeLogConditional;
import org.jenkinsci.plugins.workflow.flow.FlowExecution;

@Extension
public class WhenConditionalValidator
extends DeclarativeValidatorContributor {
    @CheckForNull
    public String validateElement(@NonNull ModelASTWhenCondition condition, @CheckForNull FlowExecution execution) {
        if (condition.getName().equals("changelog")) {
            String pattern = this.getPatternArgument(condition.getArgs());
            if (pattern == null) {
                return Messages.WhenConditionalValidator_changelog_missingParameter();
            }
            try {
                Pattern.compile(pattern);
                Pattern.compile(ChangeLogConditional.expandForMultiLine(pattern), 40);
            }
            catch (PatternSyntaxException e) {
                return Messages.WhenConditionalValidator_changelog_badPattern(pattern, e.getMessage());
            }
        }
        return null;
    }

    private String getPatternArgument(ModelASTArgumentList args) {
        if (args instanceof ModelASTSingleArgument) {
            return (String)((ModelASTSingleArgument)args).getValue().getValue();
        }
        if (args instanceof ModelASTPositionalArgumentList) {
            List arguments = ((ModelASTPositionalArgumentList)args).getArguments();
            if (!arguments.isEmpty()) {
                return (String)((ModelASTValue)arguments.get(0)).getValue();
            }
        } else if (args instanceof ModelASTNamedArgumentList) {
            return (String)((ModelASTNamedArgumentList)args).argListToMap().get("pattern");
        }
        return null;
    }
}

