/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.pipeline.modeldefinition.parser;

import hudson.ExtensionList;
import hudson.ExtensionPoint;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import org.codehaus.groovy.ast.expr.ArgumentListExpression;
import org.codehaus.groovy.ast.expr.ClosureExpression;
import org.codehaus.groovy.ast.expr.Expression;
import org.codehaus.groovy.ast.expr.MapExpression;
import org.codehaus.groovy.ast.expr.MethodCallExpression;
import org.codehaus.groovy.ast.expr.TupleExpression;
import org.codehaus.groovy.ast.expr.VariableExpression;
import org.codehaus.groovy.ast.stmt.BlockStatement;
import org.codehaus.groovy.ast.stmt.ExpressionStatement;
import org.codehaus.groovy.ast.stmt.Statement;
import org.codehaus.groovy.ast.tools.GeneralUtils;
import org.jenkinsci.plugins.pipeline.modeldefinition.ast.AbstractModelASTCodeBlock;
import org.jenkinsci.plugins.pipeline.modeldefinition.ast.ModelASTBranch;
import org.jenkinsci.plugins.pipeline.modeldefinition.ast.ModelASTBuildCondition;
import org.jenkinsci.plugins.pipeline.modeldefinition.ast.ModelASTStage;
import org.jenkinsci.plugins.pipeline.modeldefinition.ast.ModelASTStep;
import org.jenkinsci.plugins.pipeline.modeldefinition.ast.ModelASTTreeStep;

public abstract class StepRuntimeTransformerContributor
implements ExtensionPoint {
    @Nonnull
    public final ClosureExpression handleStage(@Nonnull ModelASTStage stage, @Nonnull ClosureExpression body) {
        if (stage.getBranches().size() == 1) {
            ModelASTBranch branch = (ModelASTBranch)stage.getBranches().get(0);
            body.setCode((Statement)this.handleBranch(branch));
        } else {
            TupleExpression parallelArgs;
            MethodCallExpression methExpr = this.getParallelMethod(body.getCode());
            if (methExpr != null && (parallelArgs = (TupleExpression)methExpr.getArguments()).getExpressions().size() == 1 && parallelArgs.getExpression(0) instanceof MapExpression) {
                MapExpression newParallelMap = new MapExpression();
                for (ModelASTBranch b : stage.getBranches()) {
                    newParallelMap.addMapEntryExpression((Expression)GeneralUtils.constX((Object)b.getName()), (Expression)GeneralUtils.closureX((Statement)this.handleBranch(b)));
                }
                body.setCode((Statement)GeneralUtils.block((Statement[])new Statement[]{GeneralUtils.stmt((Expression)GeneralUtils.callX((Expression)GeneralUtils.varX((String)"this"), (Expression)GeneralUtils.constX((Object)"parallel"), (Expression)GeneralUtils.args((Expression[])new Expression[]{newParallelMap})))}));
            }
        }
        return body;
    }

    @Nonnull
    public final ClosureExpression handleBuildCondition(@Nonnull ModelASTBuildCondition condition, @Nonnull ClosureExpression body) {
        body.setCode((Statement)this.handleBranch(condition.getBranch()));
        return body;
    }

    @Nonnull
    public final BlockStatement handleBranch(@Nonnull ModelASTBranch branch) {
        BlockStatement newBlock = GeneralUtils.block((Statement[])new Statement[0]);
        for (ModelASTStep s : branch.getSteps()) {
            if (s instanceof AbstractModelASTCodeBlock || !(s.getSourceLocation() instanceof ExpressionStatement)) {
                newBlock.addStatement((Statement)s.getSourceLocation());
                continue;
            }
            ExpressionStatement es = (ExpressionStatement)s.getSourceLocation();
            if (es.getExpression() instanceof MethodCallExpression) {
                MethodCallExpression methodCall = (MethodCallExpression)es.getExpression();
                newBlock.addStatement(GeneralUtils.stmt((Expression)this.handleStep(s, methodCall)));
                continue;
            }
            newBlock.addStatement((Statement)es);
        }
        return newBlock;
    }

    @Nonnull
    public final MethodCallExpression handleStep(@Nonnull ModelASTStep step, @Nonnull MethodCallExpression methodCall) {
        if (step instanceof AbstractModelASTCodeBlock) {
            return methodCall;
        }
        TupleExpression originalArgs = (TupleExpression)methodCall.getArguments();
        if (step instanceof ModelASTTreeStep && originalArgs.getExpressions().size() > 0) {
            ArgumentListExpression newArgs = new ArgumentListExpression();
            for (int i = 0; i < originalArgs.getExpressions().size() - 1; ++i) {
                newArgs.addExpression(originalArgs.getExpression(i));
            }
            ClosureExpression originalClosure = (ClosureExpression)originalArgs.getExpression(originalArgs.getExpressions().size() - 1);
            BlockStatement newBlock = GeneralUtils.block((Statement[])new Statement[0]);
            for (ModelASTStep nested : ((ModelASTTreeStep)step).getChildren()) {
                ExpressionStatement es = (ExpressionStatement)nested.getSourceLocation();
                newBlock.addStatement(GeneralUtils.stmt((Expression)this.handleStep(nested, (MethodCallExpression)es.getExpression())));
            }
            originalClosure.setCode((Statement)newBlock);
            newArgs.addExpression((Expression)originalClosure);
            methodCall.setArguments((Expression)newArgs);
        }
        return this.transformStep(step, methodCall);
    }

    @Nonnull
    public abstract MethodCallExpression transformStep(@Nonnull ModelASTStep var1, @Nonnull MethodCallExpression var2);

    @CheckForNull
    private MethodCallExpression getParallelMethod(@Nonnull Statement stmt) {
        MethodCallExpression methExpr;
        ExpressionStatement exprStmt;
        BlockStatement block;
        if (stmt instanceof BlockStatement && (block = (BlockStatement)stmt).getStatements().size() == 1 && block.getStatements().get(0) instanceof ExpressionStatement && (exprStmt = (ExpressionStatement)block.getStatements().get(0)).getExpression() instanceof MethodCallExpression && "parallel".equals((methExpr = (MethodCallExpression)exprStmt.getExpression()).getMethodAsString()) && methExpr.getReceiver() instanceof VariableExpression && "this".equals(((VariableExpression)methExpr.getReceiver()).getName()) && methExpr.getArguments() instanceof TupleExpression) {
            return methExpr;
        }
        return null;
    }

    public static ExtensionList<StepRuntimeTransformerContributor> all() {
        return ExtensionList.lookup(StepRuntimeTransformerContributor.class);
    }

    @Nonnull
    public static ClosureExpression transformStage(@Nonnull ModelASTStage stage, @Nonnull ClosureExpression body) {
        for (StepRuntimeTransformerContributor c : StepRuntimeTransformerContributor.all()) {
            body = c.handleStage(stage, body);
        }
        return body;
    }

    @Nonnull
    public static ClosureExpression transformBuildCondition(@Nonnull ModelASTBuildCondition condition, @Nonnull ClosureExpression body) {
        for (StepRuntimeTransformerContributor c : StepRuntimeTransformerContributor.all()) {
            body = c.handleBuildCondition(condition, body);
        }
        return body;
    }
}

