/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.dokka.maven;

import java.io.File;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.apache.maven.archiver.MavenArchiveConfiguration;
import org.apache.maven.archiver.MavenArchiver;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProjectHelper;
import org.codehaus.plexus.archiver.Archiver;
import org.codehaus.plexus.archiver.jar.JarArchiver;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.dokka.maven.AbstractDokkaMojo;
import org.jetbrains.dokka.maven.DokkaMojoKt;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0007\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0014\u001a\u00020\u0015H\u0016J\u0010\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\bH\u0002J\b\u0010\u0019\u001a\u00020\bH\u0014R\u0010\u0010\u0003\u001a\u00020\u00048\u0002X\u0083\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u00020\u00068\u0002X\u0083D\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\u0004\u0018\u00010\b8\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\u0004\u0018\u00010\b8\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\u0004\u0018\u00010\u000b8\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\u0004\u0018\u00010\b8\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0002\n\u0000R\u001e\u0010\r\u001a\u00020\b8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011R\u0014\u0010\u0012\u001a\u0004\u0018\u00010\u00138\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lorg/jetbrains/dokka/maven/DokkaJavadocJarMojo;", "Lorg/jetbrains/dokka/maven/AbstractDokkaMojo;", "()V", "archive", "Lorg/apache/maven/archiver/MavenArchiveConfiguration;", "attach", "", "classifier", "", "finalName", "jarArchiver", "Lorg/codehaus/plexus/archiver/jar/JarArchiver;", "jarOutputDirectory", "outputDir", "getOutputDir", "()Ljava/lang/String;", "setOutputDir", "(Ljava/lang/String;)V", "projectHelper", "Lorg/apache/maven/project/MavenProjectHelper;", "execute", "", "generateArchive", "Ljava/io/File;", "jarFileName", "getOutDir", "maven-plugin"})
@Mojo(name="javadocJar", defaultPhase=LifecyclePhase.PRE_SITE, threadSafe=true, requiresDependencyResolution=ResolutionScope.COMPILE, requiresProject=true)
public final class DokkaJavadocJarMojo
extends AbstractDokkaMojo {
    @Parameter(required=true, defaultValue="${project.basedir}/target/dokkaJavadocJar")
    @NotNull
    private String outputDir = "";
    @Parameter(property="project.build.directory")
    private String jarOutputDirectory;
    @Parameter(property="project.build.finalName")
    private String finalName;
    @Parameter(property="attach", defaultValue="true")
    private final boolean attach;
    @Parameter
    private final MavenArchiveConfiguration archive = new MavenArchiveConfiguration();
    @Parameter(property="maven.javadoc.classifier", defaultValue="javadoc", required=true)
    private String classifier;
    @Component
    private MavenProjectHelper projectHelper;
    @Component(role=Archiver.class, hint="jar")
    private JarArchiver jarArchiver;

    @NotNull
    public final String getOutputDir() {
        return this.outputDir;
    }

    public final void setOutputDir(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.outputDir = string;
    }

    @Override
    @NotNull
    protected String getOutDir() {
        return this.outputDir;
    }

    @Override
    public void execute() {
        block2: {
            super.execute();
            if (!new File(this.outputDir).exists()) {
                this.getLog().warn((CharSequence)"No javadoc generated so no javadoc jar will be generated");
                return;
            }
            File outputFile = this.generateArchive(this.finalName + '-' + this.classifier + ".jar");
            if (!this.attach) break block2;
            MavenProjectHelper mavenProjectHelper = this.projectHelper;
            if (mavenProjectHelper != null) {
                mavenProjectHelper.attachArtifact(this.getMavenProject(), "javadoc", this.classifier, outputFile);
            }
        }
    }

    private final File generateArchive(String jarFileName) {
        File javadocJar = new File(this.jarOutputDirectory, jarFileName);
        MavenArchiver archiver = new MavenArchiver();
        archiver.setArchiver(this.jarArchiver);
        archiver.setOutputFile(javadocJar);
        archiver.getArchiver().addDirectory(new File(this.outputDir), new String[]{"**/**"}, new String[0]);
        this.archive.setAddMavenDescriptor(false);
        archiver.createArchive(this.getSession(), this.getMavenProject(), this.archive);
        return javadocJar;
    }

    public DokkaJavadocJarMojo() {
        super(CollectionsKt.listOf((Object)DokkaMojoKt.access$getJavadocDependency$p()));
    }
}

