/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.gradle.tasks;

import java.io.File;
import java.util.concurrent.Callable;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.Action;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.invocation.Gradle;
import org.gradle.api.logging.Logger;
import org.gradle.api.provider.Provider;
import org.gradle.api.services.BuildServiceSpec;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.compilerRunner.GradleCompilerRunner;
import org.jetbrains.kotlin.gradle.incremental.IncrementalModuleInfoBuildService;
import org.jetbrains.kotlin.gradle.incremental.IncrementalModuleInfoProvider;
import org.jetbrains.kotlin.gradle.utils.ConfigurationCacheKt;
import org.jetbrains.kotlin.incremental.IncrementalModuleInfo;

@Metadata(mv={1, 1, 18}, bv={1, 0, 3}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u000b\u0018\u00002\u00020\u0001B\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0019\u0010\t\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u000b0\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0012\u001a\u00020\u0013\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0011\u0010\u0016\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\bR\u0011\u0010\u0018\u001a\u00020\u0013\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u0015R\u0011\u0010\u001a\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\bR\u0011\u0010\u001c\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\b\u00a8\u0006\u001e"}, d2={"Lorg/jetbrains/kotlin/gradle/tasks/GradleCompileTaskProvider;", "", "task", "Lorg/gradle/api/Task;", "(Lorg/gradle/api/Task;)V", "buildDir", "Ljava/io/File;", "getBuildDir", "()Ljava/io/File;", "buildModulesInfo", "Lorg/gradle/api/provider/Provider;", "Lorg/jetbrains/kotlin/gradle/incremental/IncrementalModuleInfoProvider;", "getBuildModulesInfo", "()Lorg/gradle/api/provider/Provider;", "logger", "Lorg/gradle/api/logging/Logger;", "getLogger", "()Lorg/gradle/api/logging/Logger;", "path", "", "getPath", "()Ljava/lang/String;", "projectDir", "getProjectDir", "projectName", "getProjectName", "rootDir", "getRootDir", "sessionsDir", "getSessionsDir", "kotlin-gradle-plugin"})
public final class GradleCompileTaskProvider {
    @NotNull
    private final String path;
    @NotNull
    private final Logger logger;
    @NotNull
    private final File buildDir;
    @NotNull
    private final File projectDir;
    @NotNull
    private final File rootDir;
    @NotNull
    private final File sessionsDir;
    @NotNull
    private final String projectName;
    @NotNull
    private final Provider<? extends IncrementalModuleInfoProvider> buildModulesInfo;

    public GradleCompileTaskProvider(@NotNull Task task) {
        Gradle gradle;
        Intrinsics.checkParameterIsNotNull((Object)task, (String)"task");
        Object object = task.getProject().getBuildDir();
        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"task.project.buildDir");
        this.buildDir = object;
        object = task.getProject().getRootProject().getProjectDir();
        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"task.project.rootProject.projectDir");
        this.projectDir = object;
        object = task.getProject().getRootProject().getRootDir();
        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"task.project.rootProject.rootDir");
        this.rootDir = object;
        object = task.getProject();
        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"task.project");
        this.sessionsDir = GradleCompilerRunner.Companion.sessionsDir$kotlin_gradle_plugin((Project)object);
        object = task.getProject().getRootProject().getName();
        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"task.project.rootProject.name");
        this.projectName = GradleCompilerRunner.Companion.normalizeForFlagFile$kotlin_gradle_plugin((String)object);
        Object object2 = task.getProject().getGradle();
        Intrinsics.checkExpressionValueIsNotNull((Object)object2, (String)"task.project.gradle");
        final IncrementalModuleInfo modulesInfo = GradleCompilerRunner.Companion.buildModulesInfo$kotlin_gradle_plugin((Gradle)object2);
        object2 = task.getProject().getGradle();
        Intrinsics.checkExpressionValueIsNotNull((Object)object2, (String)"task.project.gradle");
        if (!ConfigurationCacheKt.isConfigurationCacheAvailable(object2)) {
            object2 = task.getProject().provider((Callable)new Callable<1>(){

                @Override
                @NotNull
                public final 1 call() {
                    return new IncrementalModuleInfoProvider(){
                        @NotNull
                        private final IncrementalModuleInfo info;
                        {
                            this.info = modulesInfo;
                        }

                        @Override
                        @NotNull
                        public IncrementalModuleInfo getInfo() {
                            return this.info;
                        }
                    };
                }
            });
            Intrinsics.checkExpressionValueIsNotNull((Object)object2, (String)"val modulesInfo = GradleCompilerRunner.buildModulesInfo(task.project.gradle)\n        buildModulesInfo = if (!isConfigurationCacheAvailable(task.project.gradle)) {\n            task.project.provider {\n                object : IncrementalModuleInfoProvider {\n                    override val info = modulesInfo\n                }\n            }\n        }");
            gradle = object2;
        } else {
            object2 = task.getProject().getGradle().getSharedServices().registerIfAbsent(IncrementalModuleInfoBuildService.Companion.getServiceName(), IncrementalModuleInfoBuildService.class, (Action)new Action<BuildServiceSpec<IncrementalModuleInfoBuildService.Parameters>>(){

                public final void execute(BuildServiceSpec<IncrementalModuleInfoBuildService.Parameters> it) {
                    ((IncrementalModuleInfoBuildService.Parameters)it.getParameters()).getInfo().set((Object)modulesInfo);
                }
            });
            Intrinsics.checkExpressionValueIsNotNull((Object)object2, (String)"val modulesInfo = GradleCompilerRunner.buildModulesInfo(task.project.gradle)\n        buildModulesInfo = if (!isConfigurationCacheAvailable(task.project.gradle)) {\n            task.project.provider {\n                object : IncrementalModuleInfoProvider {\n                    override val info = modulesInfo\n                }\n            }\n        } else {\n            task.project.gradle.sharedServices.registerIfAbsent(\n                IncrementalModuleInfoBuildService.getServiceName(), IncrementalModuleInfoBuildService::class.java\n            ) {\n                it.parameters.info.set(modulesInfo)\n            }\n        }");
            gradle = object2;
        }
        this.buildModulesInfo = gradle;
        object2 = task.getPath();
        Intrinsics.checkExpressionValueIsNotNull((Object)object2, (String)"task.path");
        this.path = object2;
        object2 = task.getLogger();
        Intrinsics.checkExpressionValueIsNotNull((Object)object2, (String)"task.logger");
        this.logger = object2;
    }

    @NotNull
    public final String getPath() {
        return this.path;
    }

    @NotNull
    public final Logger getLogger() {
        return this.logger;
    }

    @NotNull
    public final File getBuildDir() {
        return this.buildDir;
    }

    @NotNull
    public final File getProjectDir() {
        return this.projectDir;
    }

    @NotNull
    public final File getRootDir() {
        return this.rootDir;
    }

    @NotNull
    public final File getSessionsDir() {
        return this.sessionsDir;
    }

    @NotNull
    public final String getProjectName() {
        return this.projectName;
    }

    @NotNull
    public final Provider<? extends IncrementalModuleInfoProvider> getBuildModulesInfo() {
        return this.buildModulesInfo;
    }
}

