/*
 * Decompiled with CFR 0.152.
 */
package kotlinx.kover.engines.jacoco;

import java.io.File;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.kover.api.CoverageEngine;
import kotlinx.kover.api.KoverTaskExtension;
import kotlinx.kover.engines.commons.CoverageAgent;
import kotlinx.kover.engines.jacoco.JacocoAgentKt;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.Dependency;
import org.gradle.api.file.FileCollection;
import org.jetbrains.annotations.NotNull;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u001e\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00100\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\b\u0010\u0017\u001a\u00020\u0018H\u0002R\u0014\u0010\u0007\u001a\u00020\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\u00020\fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lkotlinx/kover/engines/jacoco/JacocoAgent;", "Lkotlinx/kover/engines/commons/CoverageAgent;", "config", "Lorg/gradle/api/artifacts/Configuration;", "project", "Lorg/gradle/api/Project;", "(Lorg/gradle/api/artifacts/Configuration;Lorg/gradle/api/Project;)V", "classpath", "Lorg/gradle/api/file/FileCollection;", "getClasspath", "()Lorg/gradle/api/file/FileCollection;", "engine", "Lkotlinx/kover/api/CoverageEngine;", "getEngine", "()Lkotlinx/kover/api/CoverageEngine;", "agentArgs", "", "extension", "Lkotlinx/kover/api/KoverTaskExtension;", "buildCommandLineArgs", "", "task", "Lorg/gradle/api/Task;", "getJacocoJar", "Ljava/io/File;", "kover"})
final class JacocoAgent
implements CoverageAgent {
    @NotNull
    private final Configuration config;
    @NotNull
    private final Project project;
    @NotNull
    private final CoverageEngine engine;
    @NotNull
    private final FileCollection classpath;

    public JacocoAgent(@NotNull Configuration config, @NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.config = config;
        this.project = project;
        this.engine = CoverageEngine.JACOCO;
        this.classpath = (FileCollection)this.config;
    }

    @Override
    @NotNull
    public CoverageEngine getEngine() {
        return this.engine;
    }

    @Override
    @NotNull
    public FileCollection getClasspath() {
        return this.classpath;
    }

    @Override
    @NotNull
    public List<String> buildCommandLineArgs(@NotNull Task task, @NotNull KoverTaskExtension extension) {
        Intrinsics.checkNotNullParameter((Object)task, (String)"task");
        Intrinsics.checkNotNullParameter((Object)extension, (String)"extension");
        Object[] objectArray = new String[]{"-javaagent:" + this.getJacocoJar().getCanonicalPath() + '=' + this.agentArgs(extension)};
        return CollectionsKt.mutableListOf((Object[])objectArray);
    }

    private final File getJacocoJar() {
        File containedJarFile = this.config.fileCollection(JacocoAgent::getJacocoJar$lambda-0).getSingleFile();
        File file = this.project.zipTree((Object)containedJarFile).filter(JacocoAgent::getJacocoJar$lambda-1).getSingleFile();
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"project.zipTree(containe\u2026coagent.jar\" }.singleFile");
        return file;
    }

    private final String agentArgs(KoverTaskExtension extension) {
        File binary = (File)extension.getBinaryReportFile().get();
        binary.getParentFile().mkdirs();
        Object[] objectArray = new String[]{Intrinsics.stringPlus((String)"destfile=", (Object)binary.getCanonicalPath()), "append=true", "inclnolocationclasses=false", "dumponexit=true", "output=file", "jmx=false", JacocoAgentKt.access$filterString(extension.getIncludes(), "includes"), JacocoAgentKt.access$filterString(extension.getExcludes(), "excludes")};
        return CollectionsKt.joinToString$default((Iterable)CollectionsKt.listOfNotNull((Object[])objectArray), (CharSequence)",", null, null, (int)0, null, null, (int)62, null);
    }

    private static final boolean getJacocoJar$lambda-0(Dependency it) {
        return Intrinsics.areEqual((Object)it.getName(), (Object)"org.jacoco.agent");
    }

    private static final boolean getJacocoJar$lambda-1(File it) {
        return Intrinsics.areEqual((Object)it.getName(), (Object)"jacocoagent.jar");
    }
}

