/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.pdf;

import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.Image;
import java.awt.Paint;
import java.awt.RadialGradientPaint;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.font.FontRenderContext;
import java.awt.font.GlyphVector;
import java.awt.font.TextLayout;
import java.awt.geom.AffineTransform;
import java.awt.geom.Arc2D;
import java.awt.geom.Area;
import java.awt.geom.Ellipse2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Path2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RoundRectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.BufferedImageOp;
import java.awt.image.ImageObserver;
import java.awt.image.RenderedImage;
import java.awt.image.renderable.RenderableImage;
import java.text.AttributedCharacterIterator;
import java.text.AttributedString;
import java.util.Map;
import org.jfree.pdf.PDFGraphicsConfiguration;
import org.jfree.pdf.PDFHints;
import org.jfree.pdf.stream.GraphicsStream;
import org.jfree.pdf.util.Args;
import org.jfree.pdf.util.GraphicsUtils;

public final class PDFGraphics2D
extends Graphics2D {
    int width;
    int height;
    private RenderingHints hints;
    private Paint paint = Color.WHITE;
    private Color color = Color.WHITE;
    private Color background = Color.WHITE;
    private Composite composite = AlphaComposite.getInstance(3, 1.0f);
    private Stroke stroke = new BasicStroke(1.0f);
    private AffineTransform transform = new AffineTransform();
    private Shape clip = null;
    private Font font = new Font("SansSerif", 0, 12);
    private final BufferedImage image = new BufferedImage(10, 10, 1);
    private Line2D line;
    Rectangle2D rect;
    private RoundRectangle2D roundRect;
    private Ellipse2D oval;
    private Arc2D arc;
    private GraphicsStream gs;
    private GraphicsConfiguration deviceConfiguration;
    private final FontRenderContext fontRenderContext = new FontRenderContext(null, false, true);
    AffineTransform originalTransform;

    PDFGraphics2D(GraphicsStream gs, int width, int height) {
        this(gs, width, height, false);
    }

    PDFGraphics2D(GraphicsStream gs, int width, int height, boolean skipJava2DTransform) {
        Args.nullNotPermitted(gs, "gs");
        this.width = width;
        this.height = height;
        this.hints = new RenderingHints(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        this.gs = gs;
        if (!skipJava2DTransform) {
            this.gs.applyTransform(AffineTransform.getTranslateInstance(0.0, height));
            this.gs.applyTransform(AffineTransform.getScaleInstance(1.0, -1.0));
        }
        this.gs.applyFont(this.getFont());
        this.gs.applyStrokeColor(this.getColor());
        this.gs.applyFillColor(this.getColor());
        this.gs.applyStroke(this.getStroke());
    }

    @Override
    public Graphics create() {
        PDFGraphics2D copy = new PDFGraphics2D(this.gs, this.width, this.height, true);
        copy.setRenderingHints(this.getRenderingHints());
        copy.setTransform(this.getTransform());
        copy.originalTransform = this.getTransform();
        copy.setClip(this.getClip());
        copy.setPaint(this.getPaint());
        copy.setColor(this.getColor());
        copy.setComposite(this.getComposite());
        copy.setStroke(this.getStroke());
        copy.setFont(this.getFont());
        copy.setBackground(this.getBackground());
        return copy;
    }

    @Override
    public Paint getPaint() {
        return this.paint;
    }

    @Override
    public void setPaint(Paint paint) {
        if (paint == null) {
            return;
        }
        if (paint instanceof Color) {
            this.setColor((Color)paint);
            return;
        }
        this.paint = paint;
        if (paint instanceof GradientPaint) {
            GradientPaint gp = (GradientPaint)paint;
            this.gs.applyStrokeGradient(gp);
            this.gs.applyFillGradient(gp);
        } else if (paint instanceof RadialGradientPaint) {
            RadialGradientPaint rgp = (RadialGradientPaint)paint;
            this.gs.applyStrokeGradient(rgp);
            this.gs.applyFillGradient(rgp);
        }
    }

    @Override
    public Color getColor() {
        return this.color;
    }

    @Override
    public void setColor(Color c) {
        if (c == null || this.paint.equals(c)) {
            return;
        }
        this.color = c;
        this.paint = c;
        this.gs.applyStrokeColor(c);
        this.gs.applyFillColor(c);
    }

    @Override
    public Color getBackground() {
        return this.background;
    }

    @Override
    public void setBackground(Color color) {
        this.background = color;
    }

    @Override
    public Composite getComposite() {
        return this.composite;
    }

    @Override
    public void setComposite(Composite comp) {
        Args.nullNotPermitted(comp, "comp");
        this.composite = comp;
        if (comp instanceof AlphaComposite) {
            AlphaComposite ac = (AlphaComposite)comp;
            this.gs.applyComposite(ac);
        } else {
            this.gs.applyComposite(null);
        }
    }

    @Override
    public Stroke getStroke() {
        return this.stroke;
    }

    @Override
    public void setStroke(Stroke s) {
        Args.nullNotPermitted(s, "s");
        if (this.stroke.equals(s)) {
            return;
        }
        this.stroke = s;
        this.gs.applyStroke(s);
    }

    @Override
    public Object getRenderingHint(RenderingHints.Key hintKey) {
        return this.hints.get(hintKey);
    }

    @Override
    public void setRenderingHint(RenderingHints.Key hintKey, Object hintValue) {
        this.hints.put(hintKey, hintValue);
    }

    @Override
    public RenderingHints getRenderingHints() {
        return (RenderingHints)this.hints.clone();
    }

    @Override
    public void setRenderingHints(Map<?, ?> hints) {
        this.hints.clear();
        this.hints.putAll(hints);
    }

    @Override
    public void addRenderingHints(Map<?, ?> hints) {
        this.hints.putAll(hints);
    }

    private Shape invTransformedClip(Shape clip) {
        Shape result = clip;
        try {
            AffineTransform inv = this.transform.createInverse();
            result = inv.createTransformedShape(clip);
        }
        catch (NoninvertibleTransformException noninvertibleTransformException) {
            // empty catch block
        }
        return result;
    }

    @Override
    public void draw(Shape s) {
        if (!(this.stroke instanceof BasicStroke)) {
            this.fill(this.stroke.createStrokedShape(s));
            return;
        }
        if (s instanceof Line2D) {
            if (this.clip != null) {
                this.gs.pushGraphicsState();
                this.gs.applyClip(this.invTransformedClip(this.clip));
                this.gs.drawLine((Line2D)s);
                this.gs.popGraphicsState();
            } else {
                this.gs.drawLine((Line2D)s);
            }
        } else if (s instanceof Path2D) {
            if (this.clip != null) {
                this.gs.pushGraphicsState();
                this.gs.applyClip(this.invTransformedClip(this.clip));
                this.gs.drawPath2D((Path2D)s);
                this.gs.popGraphicsState();
            } else {
                this.gs.drawPath2D((Path2D)s);
            }
        } else {
            this.draw(new GeneralPath(s));
        }
    }

    @Override
    public void fill(Shape s) {
        if (s instanceof Path2D) {
            if (this.clip != null) {
                this.gs.pushGraphicsState();
                this.gs.applyClip(this.invTransformedClip(this.clip));
                this.gs.fillPath2D((Path2D)s);
                this.gs.popGraphicsState();
            } else {
                this.gs.fillPath2D((Path2D)s);
            }
        } else {
            this.fill(new GeneralPath(s));
        }
    }

    @Override
    public Font getFont() {
        return this.font;
    }

    @Override
    public void setFont(Font font) {
        if (font == null || this.font.equals(font)) {
            return;
        }
        this.font = font;
        this.gs.applyFont(font);
    }

    @Override
    public FontMetrics getFontMetrics(Font f) {
        return this.image.createGraphics().getFontMetrics(f);
    }

    @Override
    public FontRenderContext getFontRenderContext() {
        return this.fontRenderContext;
    }

    @Override
    public void drawString(String str, int x, int y) {
        this.drawString(str, (float)x, (float)y);
    }

    @Override
    public void drawString(String str, float x, float y) {
        if (str == null) {
            throw new NullPointerException("Null 'str' argument.");
        }
        if (str.isEmpty()) {
            return;
        }
        if (this.clip != null) {
            this.gs.pushGraphicsState();
            this.gs.applyClip(this.invTransformedClip(this.clip));
        }
        if (!PDFHints.VALUE_DRAW_STRING_TYPE_VECTOR.equals(this.hints.get(PDFHints.KEY_DRAW_STRING_TYPE))) {
            this.gs.drawString(str, x, y);
        } else {
            AttributedString as = new AttributedString(str, this.font.getAttributes());
            this.drawString(as.getIterator(), x, y);
        }
        if (this.clip != null) {
            this.gs.popGraphicsState();
        }
    }

    @Override
    public void drawString(AttributedCharacterIterator iterator, int x, int y) {
        this.drawString(iterator, (float)x, (float)y);
    }

    @Override
    public void drawString(AttributedCharacterIterator iterator, float x, float y) {
        TextLayout layout = new TextLayout(iterator, this.getFontRenderContext());
        layout.draw(this, x, y);
    }

    @Override
    public void drawGlyphVector(GlyphVector g, float x, float y) {
        this.fill(g.getOutline(x, y));
    }

    @Override
    public void translate(int tx, int ty) {
        this.translate((double)tx, (double)ty);
    }

    @Override
    public void translate(double tx, double ty) {
        AffineTransform t = this.getTransform();
        t.translate(tx, ty);
        this.setTransform(t);
    }

    @Override
    public void rotate(double theta) {
        AffineTransform t = this.getTransform();
        t.rotate(theta);
        this.setTransform(t);
    }

    @Override
    public void rotate(double theta, double x, double y) {
        this.translate(x, y);
        this.rotate(theta);
        this.translate(-x, -y);
    }

    @Override
    public void scale(double sx, double sy) {
        AffineTransform t = this.getTransform();
        t.scale(sx, sy);
        this.setTransform(t);
    }

    @Override
    public void shear(double shx, double shy) {
        AffineTransform t = AffineTransform.getShearInstance(shx, shy);
        this.transform(t);
    }

    @Override
    public void transform(AffineTransform t) {
        AffineTransform tx = this.getTransform();
        tx.concatenate(t);
        this.setTransform(tx);
    }

    @Override
    public AffineTransform getTransform() {
        return (AffineTransform)this.transform.clone();
    }

    @Override
    public void setTransform(AffineTransform t) {
        this.transform = t == null ? new AffineTransform() : new AffineTransform(t);
        this.gs.setTransform(this.transform);
    }

    @Override
    public boolean hit(Rectangle rect, Shape s, boolean onStroke) {
        Shape ts = onStroke ? this.transform.createTransformedShape(this.stroke.createStrokedShape(s)) : this.transform.createTransformedShape(s);
        if (!rect.getBounds2D().intersects(ts.getBounds2D())) {
            return false;
        }
        Area a1 = new Area(rect);
        Area a2 = new Area(ts);
        a1.intersect(a2);
        return !a1.isEmpty();
    }

    @Override
    public GraphicsConfiguration getDeviceConfiguration() {
        if (this.deviceConfiguration == null) {
            this.deviceConfiguration = new PDFGraphicsConfiguration(this.width, this.height);
        }
        return this.deviceConfiguration;
    }

    @Override
    public void setPaintMode() {
    }

    @Override
    public void setXORMode(Color c) {
    }

    @Override
    public Shape getClip() {
        if (this.clip == null) {
            return null;
        }
        try {
            AffineTransform inv = this.transform.createInverse();
            return inv.createTransformedShape(this.clip);
        }
        catch (NoninvertibleTransformException ex) {
            return null;
        }
    }

    @Override
    public void setClip(Shape shape) {
        this.clip = this.transform.createTransformedShape(shape);
    }

    @Override
    public Rectangle getClipBounds() {
        Shape s = this.getClip();
        return s != null ? s.getBounds() : null;
    }

    @Override
    public void clip(Shape s) {
        if (this.clip == null) {
            this.setClip(s);
            return;
        }
        Shape ts = this.transform.createTransformedShape(s);
        if (!ts.intersects(this.clip.getBounds2D())) {
            this.setClip(new Rectangle2D.Double());
        } else {
            Area a1 = new Area(ts);
            Area a2 = new Area(this.clip);
            a1.intersect(a2);
            this.clip = new Path2D.Double(a1);
        }
    }

    @Override
    public void clipRect(int x, int y, int width, int height) {
        this.setRect(x, y, width, height);
        this.clip(this.rect);
    }

    @Override
    public void setClip(int x, int y, int width, int height) {
        this.setClip(new Rectangle(x, y, width, height));
    }

    @Override
    public void drawLine(int x1, int y1, int x2, int y2) {
        if (this.line == null) {
            this.line = new Line2D.Double(x1, y1, x2, y2);
        } else {
            this.line.setLine(x1, y1, x2, y2);
        }
        this.draw(this.line);
    }

    @Override
    public void fillRect(int x, int y, int width, int height) {
        if (this.rect == null) {
            this.rect = new Rectangle2D.Double(x, y, width, height);
        } else {
            this.rect.setRect(x, y, width, height);
        }
        this.fill(this.rect);
    }

    @Override
    public void clearRect(int x, int y, int width, int height) {
        if (this.getBackground() == null) {
            return;
        }
        Paint saved = this.getPaint();
        this.setPaint(this.getBackground());
        this.fillRect(x, y, width, height);
        this.setPaint(saved);
    }

    @Override
    public void drawRoundRect(int x, int y, int width, int height, int arcWidth, int arcHeight) {
        this.setRoundRect(x, y, width, height, arcWidth, arcHeight);
        this.draw(this.roundRect);
    }

    @Override
    public void fillRoundRect(int x, int y, int width, int height, int arcWidth, int arcHeight) {
        this.setRoundRect(x, y, width, height, arcWidth, arcHeight);
        this.fill(this.roundRect);
    }

    @Override
    public void drawOval(int x, int y, int width, int height) {
        this.setOval(x, y, width, height);
        this.draw(this.oval);
    }

    @Override
    public void fillOval(int x, int y, int width, int height) {
        this.setOval(x, y, width, height);
        this.fill(this.oval);
    }

    @Override
    public void drawArc(int x, int y, int width, int height, int startAngle, int arcAngle) {
        this.setArc(x, y, width, height, startAngle, arcAngle);
        this.draw(this.arc);
    }

    @Override
    public void fillArc(int x, int y, int width, int height, int startAngle, int arcAngle) {
        this.setArc(x, y, width, height, startAngle, arcAngle);
        this.fill(this.arc);
    }

    @Override
    public void drawPolyline(int[] xPoints, int[] yPoints, int nPoints) {
        GeneralPath p = GraphicsUtils.createPolygon(xPoints, yPoints, nPoints, false);
        this.draw(p);
    }

    @Override
    public void drawPolygon(int[] xPoints, int[] yPoints, int nPoints) {
        GeneralPath p = GraphicsUtils.createPolygon(xPoints, yPoints, nPoints, true);
        this.draw(p);
    }

    @Override
    public void fillPolygon(int[] xPoints, int[] yPoints, int nPoints) {
        GeneralPath p = GraphicsUtils.createPolygon(xPoints, yPoints, nPoints, true);
        this.fill(p);
    }

    @Override
    public boolean drawImage(Image img, AffineTransform xform, ImageObserver observer) {
        AffineTransform savedTransform = this.getTransform();
        if (xform != null) {
            this.transform(xform);
        }
        boolean result = this.drawImage(img, 0, 0, observer);
        if (xform != null) {
            this.setTransform(savedTransform);
        }
        return result;
    }

    @Override
    public void drawImage(BufferedImage img, BufferedImageOp op, int x, int y) {
        BufferedImage imageToDraw = img;
        if (op != null) {
            imageToDraw = op.filter(img, null);
        }
        this.drawImage(imageToDraw, new AffineTransform(1.0f, 0.0f, 0.0f, 1.0f, x, y), null);
    }

    @Override
    public void drawRenderedImage(RenderedImage img, AffineTransform xform) {
        if (img == null) {
            return;
        }
        BufferedImage bi = GraphicsUtils.convertRenderedImage(img);
        this.drawImage(bi, xform, null);
    }

    @Override
    public void drawRenderableImage(RenderableImage img, AffineTransform xform) {
        RenderedImage ri = img.createDefaultRendering();
        this.drawRenderedImage(ri, xform);
    }

    @Override
    public boolean drawImage(Image img, int x, int y, ImageObserver observer) {
        int w = img.getWidth(observer);
        if (w < 0) {
            return false;
        }
        int h = img.getHeight(observer);
        if (h < 0) {
            return false;
        }
        return this.drawImage(img, x, y, w, h, observer);
    }

    @Override
    public boolean drawImage(Image img, int x, int y, int w, int h, ImageObserver observer) {
        if (this.clip != null) {
            this.gs.pushGraphicsState();
            this.gs.applyClip(this.invTransformedClip(this.clip));
            this.gs.drawImage(img, x, y, w, h);
            this.gs.popGraphicsState();
        } else {
            this.gs.drawImage(img, x, y, w, h);
        }
        return true;
    }

    @Override
    public boolean drawImage(Image img, int x, int y, Color bgcolor, ImageObserver observer) {
        int w = img.getWidth(null);
        if (w < 0) {
            return false;
        }
        int h = img.getHeight(null);
        if (h < 0) {
            return false;
        }
        return this.drawImage(img, x, y, w, h, bgcolor, observer);
    }

    @Override
    public boolean drawImage(Image img, int x, int y, int w, int h, Color bgcolor, ImageObserver observer) {
        Paint saved = this.getPaint();
        this.setPaint(bgcolor);
        this.fillRect(x, y, w, h);
        this.setPaint(saved);
        return this.drawImage(img, x, y, w, h, observer);
    }

    @Override
    public boolean drawImage(Image img, int dx1, int dy1, int dx2, int dy2, int sx1, int sy1, int sx2, int sy2, ImageObserver observer) {
        int w = dx2 - dx1;
        int h = dy2 - dy1;
        BufferedImage img2 = new BufferedImage(w, h, 2);
        Graphics2D g2 = img2.createGraphics();
        g2.drawImage(img, 0, 0, w, h, sx1, sy1, sx2, sy2, null);
        return this.drawImage((Image)img2, dx1, dy1, null);
    }

    @Override
    public boolean drawImage(Image img, int dx1, int dy1, int dx2, int dy2, int sx1, int sy1, int sx2, int sy2, Color bgcolor, ImageObserver observer) {
        Paint saved = this.getPaint();
        this.setPaint(bgcolor);
        this.fillRect(dx1, dy1, dx2 - dx1, dy2 - dy1);
        this.setPaint(saved);
        return this.drawImage(img, dx1, dy1, dx2, dy2, sx1, sy1, sx2, sy2, observer);
    }

    @Override
    public void copyArea(int x, int y, int width, int height, int dx, int dy) {
    }

    @Override
    public void dispose() {
        if (this.originalTransform != null) {
            this.gs.setTransform(this.originalTransform);
        }
    }

    private void setRect(int x, int y, int width, int height) {
        if (this.rect == null) {
            this.rect = new Rectangle2D.Double(x, y, width, height);
        } else {
            this.rect.setRect(x, y, width, height);
        }
    }

    private void setRoundRect(int x, int y, int width, int height, int arcWidth, int arcHeight) {
        if (this.roundRect == null) {
            this.roundRect = new RoundRectangle2D.Double(x, y, width, height, arcWidth, arcHeight);
        } else {
            this.roundRect.setRoundRect(x, y, width, height, arcWidth, arcHeight);
        }
    }

    private void setOval(int x, int y, int width, int height) {
        if (this.oval == null) {
            this.oval = new Ellipse2D.Double(x, y, width, height);
        } else {
            this.oval.setFrame(x, y, width, height);
        }
    }

    private void setArc(int x, int y, int width, int height, int startAngle, int arcAngle) {
        if (this.arc == null) {
            this.arc = new Arc2D.Double(x, y, width, height, startAngle, arcAngle, 0);
        } else {
            this.arc.setArc(x, y, width, height, startAngle, arcAngle, 0);
        }
    }
}

