/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.build.extractor.go;

import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.jfrog.build.api.util.Log;
import org.jfrog.build.extractor.executor.CommandExecutor;
import org.jfrog.build.extractor.executor.CommandResults;

public class GoDriver
implements Serializable {
    private static final List<String> GO_LIST_USED_MODULES_CMD = Arrays.asList("list", "-f", "\"{{with .Module}}{{.Path}} {{.Version}}{{end}}\"", "all");
    private static final List<String> GO_MOD_TIDY_CMD = Arrays.asList("mod", "tidy");
    private static final String GO_MOD_GRAPH_CMD = "mod graph";
    private static final String GO_LIST_MODULE_CMD = "list -m";
    private static final String GO_VERSION_CMD = "version";
    private static final long serialVersionUID = 1L;
    private final CommandExecutor commandExecutor;
    private final File workingDirectory;
    private final Log logger;

    public GoDriver(String executablePath, Map<String, String> env, File workingDirectory, Log logger) {
        this.commandExecutor = new CommandExecutor((String)StringUtils.defaultIfEmpty((CharSequence)executablePath, (CharSequence)"go"), env);
        this.workingDirectory = workingDirectory;
        this.logger = logger;
    }

    public CommandResults runCmd(String args, boolean verbose) throws IOException {
        ArrayList<String> argsList = new ArrayList<String>(Arrays.asList(args.split(" ")));
        return this.runCmd(argsList, verbose);
    }

    public CommandResults runCmd(List<String> args, boolean verbose) throws IOException {
        CommandResults goCmdResult;
        try {
            goCmdResult = this.commandExecutor.exeCommand(this.workingDirectory, args, null, this.logger);
        }
        catch (IOException | InterruptedException e) {
            throw new IOException("Go execution failed", e);
        }
        if (!goCmdResult.isOk()) {
            throw new IOException(goCmdResult.getErr());
        }
        if (verbose) {
            this.logger.info(goCmdResult.getErr() + goCmdResult.getRes());
        }
        return goCmdResult;
    }

    public boolean isInstalled() {
        try {
            this.version(false);
            return true;
        }
        catch (IOException e) {
            return false;
        }
    }

    public CommandResults version(boolean verbose) throws IOException {
        return this.runCmd(GO_VERSION_CMD, verbose);
    }

    public CommandResults modGraph(boolean verbose) throws IOException {
        return this.runCmd(GO_MOD_GRAPH_CMD, verbose);
    }

    public void modTidy(boolean verbose, boolean ignoreErrors) throws IOException {
        ArrayList<String> argsList = new ArrayList<String>(GO_MOD_TIDY_CMD);
        if (ignoreErrors) {
            argsList.add("-e");
        }
        this.runCmd(argsList, verbose);
    }

    public CommandResults getUsedModules(boolean verbose, boolean ignoreErrors) throws IOException {
        ArrayList<String> argsList = new ArrayList<String>(GO_LIST_USED_MODULES_CMD);
        if (ignoreErrors) {
            argsList.add(1, "-e");
        }
        return this.runCmd(argsList, verbose);
    }

    public String getModuleName() throws IOException {
        CommandResults commandResults = this.runCmd(GO_LIST_MODULE_CMD, false);
        return commandResults.getRes().trim();
    }
}

