/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.build.extractor.pip.extractor;

import java.io.IOException;
import java.io.PrintStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.jfrog.build.api.util.Log;
import org.jfrog.build.extractor.ci.BuildInfo;
import org.jfrog.build.extractor.clientConfiguration.ArtifactoryClientConfiguration;
import org.jfrog.build.extractor.clientConfiguration.ArtifactoryManagerBuilder;
import org.jfrog.build.extractor.clientConfiguration.client.artifactory.ArtifactoryManager;
import org.jfrog.build.extractor.packageManager.PackageManagerExtractor;
import org.jfrog.build.extractor.packageManager.PackageManagerUtils;
import org.jfrog.build.extractor.pip.PipDriver;
import org.jfrog.build.extractor.pip.extractor.PipBuildInfoExtractor;

public class PipInstall
extends PackageManagerExtractor {
    private static final long serialVersionUID = 1L;
    private static final String ARTIFACTORY_PIP_API_START = "/api/pypi/";
    private static final String ARTIFACTORY_PIP_API_END = "/simple";
    private final ArtifactoryManagerBuilder artifactoryManagerBuilder;
    private PipDriver pipDriver;
    private Path workingDir;
    private String repo;
    private Log logger;
    private Path path;
    private List<String> installArgs;
    private String username;
    private String password;
    private String module;

    public PipInstall(ArtifactoryManagerBuilder artifactoryManagerBuilder, String resolutionRepository, String installArgs, Log logger, Path path, Map<String, String> env, String module, String username, String password, String envActivation) {
        this.artifactoryManagerBuilder = artifactoryManagerBuilder;
        this.path = path;
        this.logger = logger;
        this.repo = resolutionRepository;
        this.username = username;
        this.password = password;
        this.pipDriver = StringUtils.isNotBlank((CharSequence)envActivation) ? new PipDriver(envActivation + " && pip", env) : new PipDriver("pip", env);
        this.workingDir = Files.isDirectory(path, new LinkOption[0]) ? path : path.toAbsolutePath().getParent();
        this.installArgs = StringUtils.isBlank((CharSequence)installArgs) ? new ArrayList<String>() : Arrays.asList(installArgs.trim().split("\\s+"));
        this.module = StringUtils.isBlank((CharSequence)module) ? this.workingDir.getFileName().toString() : module;
    }

    public static void main(String[] ignored) {
        try {
            ArtifactoryClientConfiguration clientConfiguration = PackageManagerUtils.createArtifactoryClientConfiguration();
            ArtifactoryManagerBuilder artifactoryManagerBuilder = (ArtifactoryManagerBuilder)new ArtifactoryManagerBuilder().setClientConfiguration(clientConfiguration, (ArtifactoryClientConfiguration.RepositoryConfiguration)clientConfiguration.resolver);
            ArtifactoryClientConfiguration.PackageManagerHandler pipHandler = clientConfiguration.packageManagerHandler;
            PipInstall pipInstall = new PipInstall(artifactoryManagerBuilder, clientConfiguration.resolver.getRepoKey(), pipHandler.getArgs(), clientConfiguration.getLog(), Paths.get(pipHandler.getPath() != null ? pipHandler.getPath() : ".", new String[0]), clientConfiguration.getAllProperties(), pipHandler.getModule(), clientConfiguration.resolver.getUsername(), clientConfiguration.resolver.getPassword(), clientConfiguration.pipHandler.getEnvActivation());
            pipInstall.executeAndSaveBuildInfo(clientConfiguration);
        }
        catch (RuntimeException e) {
            ExceptionUtils.printRootCauseStackTrace((Throwable)e, (PrintStream)System.out);
            System.exit(1);
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public BuildInfo execute() {
        try {
            Throwable throwable = null;
            try (ArtifactoryManager artifactoryManager = this.artifactoryManagerBuilder.build();){
                PipInstall.validateRepoExists((ArtifactoryManager)artifactoryManager, (String)this.repo, (String)"Source repo must be specified");
                String artifactoryUrlWithCredentials = PackageManagerUtils.createArtifactoryUrlWithCredentials((String)artifactoryManager.getUrl(), (String)this.username, (String)this.password, (String)(ARTIFACTORY_PIP_API_START + this.repo + ARTIFACTORY_PIP_API_END));
                String installLog = this.pipDriver.install(this.path.toFile(), artifactoryUrlWithCredentials, this.installArgs, this.logger);
                this.logger.info(installLog);
                PipBuildInfoExtractor buildInfoExtractor = new PipBuildInfoExtractor();
                try {
                    BuildInfo buildInfo = buildInfoExtractor.extract(artifactoryManager, this.repo, installLog, this.path, this.module, this.logger);
                    return buildInfo;
                }
                catch (IOException e) {
                    try {
                        throw new IOException("Build info collection failed", e);
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                }
            }
        }
        catch (Exception e) {
            this.logger.error(e.getMessage(), (Throwable)e);
            throw new RuntimeException(e);
        }
    }
}

