/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.build.extractor.pip.extractor;

import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.mutable.MutableBoolean;
import org.jfrog.build.api.util.Log;

public class PipLogParser {
    static final Pattern COLLECTING_PACKAGE_PATTERN = Pattern.compile("^Collecting\\s(\\w[\\w-\\.]+)");
    static final Pattern DOWNLOADED_FILE_PATTERN = Pattern.compile("^\\s\\sDownloading\\s[^\\s]*\\/packages\\/[^\\s]*\\/([^\\s]*)");
    static final Pattern INSTALLED_PACKAGE_PATTERN = Pattern.compile("^Requirement\\salready\\ssatisfied\\:\\s(\\w[\\w-\\.]+)");

    static Map<String, String> parse(String installationLog, Log logger) {
        HashMap<String, String> downloadedDependencies = new HashMap<String, String>();
        String[] lines = installationLog.split("\\R");
        MutableBoolean expectingPackageFilePath = new MutableBoolean(false);
        String packageName = "";
        for (String line : lines) {
            Matcher matcher = COLLECTING_PACKAGE_PATTERN.matcher(line);
            if (matcher.find()) {
                packageName = PipLogParser.extractPackageName(downloadedDependencies, matcher, packageName, expectingPackageFilePath, logger);
                continue;
            }
            matcher = DOWNLOADED_FILE_PATTERN.matcher(line);
            if (matcher.find()) {
                PipLogParser.extractDownloadedFileName(downloadedDependencies, matcher, packageName, expectingPackageFilePath, logger);
                continue;
            }
            matcher = INSTALLED_PACKAGE_PATTERN.matcher(line);
            if (!matcher.find()) continue;
            PipLogParser.extractAlreadyInstalledPackage(downloadedDependencies, matcher, logger);
        }
        if (expectingPackageFilePath.isTrue()) {
            downloadedDependencies.put(StringUtils.lowerCase((String)packageName), "");
        }
        return downloadedDependencies;
    }

    static String extractPackageName(Map<String, String> downloadedDependencies, Matcher matcher, String packageName, MutableBoolean expectingPackageFilePath, Log logger) {
        if (expectingPackageFilePath.isTrue()) {
            logger.debug(String.format("Could not resolve download path for package: %s, continuing...", packageName));
            downloadedDependencies.put(StringUtils.lowerCase((String)packageName), "");
        }
        expectingPackageFilePath.setTrue();
        return matcher.group(1);
    }

    static void extractDownloadedFileName(Map<String, String> downloadedDependencies, Matcher matcher, String packageName, MutableBoolean expectingPackageFilePath, Log logger) {
        if (expectingPackageFilePath.isFalse()) {
            logger.debug(String.format("Could not determine package-name for path: %s, continuing...", matcher.group(1)));
            return;
        }
        String filePath = matcher.group(1);
        downloadedDependencies.put(StringUtils.lowerCase((String)packageName), filePath);
        expectingPackageFilePath.setFalse();
        logger.debug(String.format("Found package: %s installed with: %s", packageName, filePath));
    }

    static void extractAlreadyInstalledPackage(Map<String, String> downloadedDependencies, Matcher matcher, Log logger) {
        downloadedDependencies.put(StringUtils.lowerCase((String)matcher.group(1)), "");
        logger.debug(String.format("Found package: %s  already installed", matcher.group(1)));
    }
}

