/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.build.extractor.clientConfiguration;

import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ConcurrentSkipListMap;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.jfrog.build.api.BlackDuckProperties;
import org.jfrog.build.api.Build;
import org.jfrog.build.api.Issue;
import org.jfrog.build.api.util.Log;
import org.jfrog.build.extractor.clientConfiguration.ArtifactSpecs;
import org.jfrog.build.extractor.clientConfiguration.IncludeExcludePatterns;
import org.jfrog.build.extractor.clientConfiguration.PatternMatcher;
import org.jfrog.build.extractor.clientConfiguration.PrefixPropertyHandler;
import org.jfrog.build.extractor.clientConfiguration.util.IssuesTrackerUtils;

public class ArtifactoryClientConfiguration {
    public final ResolverHandler resolver;
    public final PublisherHandler publisher;
    public final BuildInfoHandler info;
    public final ProxyHandler proxy;
    private final PrefixPropertyHandler root;
    private final PrefixPropertyHandler rootConfig;

    public ArtifactoryClientConfiguration(Log log) {
        this.root = new PrefixPropertyHandler(log, new ConcurrentSkipListMap<String, String>());
        this.rootConfig = new PrefixPropertyHandler(this.root, "buildInfoConfig.");
        this.resolver = new ResolverHandler();
        this.publisher = new PublisherHandler();
        this.info = new BuildInfoHandler();
        this.proxy = new ProxyHandler();
    }

    public void fillFromProperties(Map<String, String> props, IncludeExcludePatterns patterns) {
        for (Map.Entry<String, String> entry : props.entrySet()) {
            String varKey = entry.getKey();
            if (PatternMatcher.pathConflicts(varKey, patterns)) continue;
            this.root.setStringValue(varKey, entry.getValue());
        }
    }

    public void fillFromProperties(Properties props) {
        this.fillFromProperties(props, (Set<String>)null);
    }

    public void fillFromProperties(Properties props, Set<String> excludeIfAlreadyExists) {
        for (Map.Entry<Object, Object> entry : props.entrySet()) {
            String key = (String)entry.getKey();
            if (excludeIfAlreadyExists != null && excludeIfAlreadyExists.contains(key) && this.root.getStringValue(key) != null) continue;
            this.root.setStringValue(key, (String)entry.getValue());
        }
    }

    public Map<String, String> getAllProperties() {
        return this.root.props;
    }

    public Map<String, String> getAllRootConfig() {
        return this.rootConfig.props;
    }

    public Log getLog() {
        return this.root.getLog();
    }

    public void persistToPropertiesFile() {
        if (StringUtils.isEmpty((String)this.getPropertiesFile())) {
            return;
        }
        Properties props = new Properties();
        props.putAll(ArtifactoryClientConfiguration.filterMapNullValues(this.root.props));
        props.putAll(ArtifactoryClientConfiguration.filterMapNullValues(this.rootConfig.props));
        FileOutputStream fos = null;
        try {
            fos = new FileOutputStream(new File(this.getPropertiesFile()).getCanonicalFile());
            props.store(fos, "BuildInfo configuration property file");
        }
        catch (IOException e) {
            try {
                throw new RuntimeException(e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(fos);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((OutputStream)fos);
    }

    public static Map<String, String> filterMapNullValues(Map<String, String> map) {
        HashMap<String, String> result = new HashMap<String, String>();
        for (Map.Entry<String, String> entry : map.entrySet()) {
            if (!StringUtils.isNotBlank((String)entry.getValue())) continue;
            result.put(entry.getKey(), entry.getValue());
        }
        return result;
    }

    @Deprecated
    public String getContextUrl() {
        return this.root.getStringValue("artifactory.contextUrl");
    }

    public void setTimeoutSec(Integer timeout) {
        this.setTimeout(timeout);
    }

    public Integer getTimeout() {
        return this.root.getIntegerValue("artifactory.timeout");
    }

    public void setTimeout(Integer timeout) {
        this.root.setIntegerValue("artifactory.timeout", timeout);
    }

    public void setConnectionRetries(Integer connectionRetries) {
        this.root.setIntegerValue("artifactory.connectionRetries", connectionRetries);
    }

    public Integer getConnectionRetries() {
        return this.root.getIntegerValue("artifactory.connectionRetries");
    }

    public Integer getSocketTimeout() {
        return this.root.getIntegerValue("artifactory.timeout.socket");
    }

    public void setSocketTimeout(Integer socketTimeout) {
        this.root.setIntegerValue("artifactory.timeout.socket", socketTimeout);
    }

    public Integer getMaxTotalConnection() {
        return this.root.getIntegerValue("artifactory.maxTotalCon");
    }

    public void setMaxTotalConnection(Integer maxTotalConnection) {
        this.root.setIntegerValue("artifactory.maxTotalCon", maxTotalConnection);
    }

    public Integer getMaxConnectionPerRoute() {
        return this.root.getIntegerValue("artifactory.maxConPerRoute");
    }

    public void setMaxConnectionPerRoute(Integer maxConnectionPerRoute) {
        this.root.setIntegerValue("artifactory.maxConPerRoute", maxConnectionPerRoute);
    }

    public String getPropertiesFile() {
        return this.rootConfig.getStringValue("propertiesFile");
    }

    public void setPropertiesFile(String propertyFile) {
        this.rootConfig.setStringValue("propertiesFile", propertyFile);
    }

    public String getExportFile() {
        return this.rootConfig.getStringValue("exportFile");
    }

    public void setExportFile(String exportFile) {
        this.rootConfig.setStringValue("exportFile", exportFile);
    }

    public void setIncludeEnvVars(Boolean enabled) {
        this.rootConfig.setBooleanValue("includeEnvVars", enabled);
    }

    public Boolean isIncludeEnvVars() {
        return this.rootConfig.getBooleanValue("includeEnvVars", false);
    }

    public String getEnvVarsIncludePatterns() {
        return this.rootConfig.getStringValue("envVarsIncludePatterns");
    }

    public void setEnvVarsIncludePatterns(String patterns) {
        this.rootConfig.setStringValue("envVarsIncludePatterns", patterns);
    }

    public String getEnvVarsExcludePatterns() {
        return this.rootConfig.getStringValue("envVarsExcludePatterns");
    }

    public void setEnvVarsExcludePatterns(String patterns) {
        this.rootConfig.setStringValue("envVarsExcludePatterns", patterns);
    }

    public void setActivateRecorder(Boolean activateRecorder) {
        this.root.setBooleanValue("org.jfrog.build.extractor.maven.recorder.activate", activateRecorder);
    }

    public Boolean isActivateRecorder() {
        return this.root.getBooleanValue("org.jfrog.build.extractor.maven.recorder.activate", false);
    }

    public class BuildInfoHandler
    extends PrefixPropertyHandler {
        public final LicenseControlHandler licenseControl;
        public final IssuesTrackerHandler issues;
        public final BlackDuckPropertiesHandler blackDuckProperties;
        private final Predicate<String> buildVariablesPredicate;
        private final Predicate<String> buildRunParametersPredicate;

        public BuildInfoHandler() {
            super(ArtifactoryClientConfiguration.this.root, "buildInfo.");
            this.licenseControl = new LicenseControlHandler();
            this.issues = new IssuesTrackerHandler();
            this.blackDuckProperties = new BlackDuckPropertiesHandler();
            this.buildVariablesPredicate = new Predicate<String>(){

                public boolean apply(String input) {
                    return input.startsWith("buildInfo.env.");
                }
            };
            this.buildRunParametersPredicate = new Predicate<String>(){

                public boolean apply(String input) {
                    return input.startsWith("buildInfo.runParameters.");
                }
            };
        }

        public String getBuildName() {
            return this.getStringValue("build.name");
        }

        public void setBuildName(String buildName) {
            this.setStringValue("build.name", buildName);
        }

        public String getBuildNumber() {
            return this.getStringValue("build.number");
        }

        public void setBuildNumber(String buildNumber) {
            this.setStringValue("build.number", buildNumber);
        }

        public String getBuildTimestamp() {
            return this.getStringValue("build.timestamp");
        }

        public void setBuildTimestamp(String timestamp) {
            this.setStringValue("build.timestamp", timestamp);
        }

        public void setBuildStarted(String isoStarted) {
            this.setStringValue("build.started", isoStarted);
        }

        public String getBuildStarted() {
            return this.getStringValue("build.started");
        }

        public void setBuildStarted(long timestamp) {
            this.setBuildStarted(Build.formatBuildStarted((long)timestamp));
        }

        public String getPrincipal() {
            return this.getStringValue("principal");
        }

        public void setPrincipal(String principal) {
            this.setStringValue("principal", principal);
        }

        public String getArtifactoryPluginVersion() {
            return this.getStringValue("artifactoryPluginVersion");
        }

        public void setArtifactoryPluginVersion(String artifactoryPluginVersion) {
            this.setStringValue("artifactoryPluginVersion", artifactoryPluginVersion);
        }

        public String getBuildUrl() {
            return this.getStringValue("buildUrl");
        }

        public void setBuildUrl(String buildUrl) {
            this.setStringValue("buildUrl", buildUrl);
        }

        public String getVcsRevision() {
            return this.getStringValue("vcs.revision");
        }

        public void setVcsRevision(String vcsRevision) {
            this.setStringValue("vcs.revision", vcsRevision);
        }

        public String getVcsUrl() {
            return this.getStringValue("vcs.url");
        }

        public void setVcsUrl(String vcsUrl) {
            this.setStringValue("vcs.url", vcsUrl);
        }

        public String getAgentName() {
            return this.getStringValue("agent.name");
        }

        public void setAgentName(String agentName) {
            this.setStringValue("agent.name", agentName);
        }

        public String getAgentVersion() {
            return this.getStringValue("agent.version");
        }

        public void setAgentVersion(String agentVersion) {
            this.setStringValue("agent.version", agentVersion);
        }

        public String getBuildAgentName() {
            return this.getStringValue("buildAgent.name");
        }

        public void setBuildAgentName(String buildAgentName) {
            this.setStringValue("buildAgent.name", buildAgentName);
        }

        public String getBuildAgentVersion() {
            return this.getStringValue("buildAgent.version");
        }

        public void setBuildAgentVersion(String buildAgentVersion) {
            this.setStringValue("buildAgent.version", buildAgentVersion);
        }

        public String getParentBuildName() {
            return this.getStringValue("build.parentName");
        }

        public void setParentBuildName(String parentBuildName) {
            this.setStringValue("build.parentName", parentBuildName);
        }

        public String getParentBuildNumber() {
            return this.getStringValue("build.parentNumber");
        }

        public void setParentBuildNumber(String parentBuildNumber) {
            this.setStringValue("build.parentNumber", parentBuildNumber);
        }

        public void setDeleteBuildArtifacts(Boolean deleteBuildArtifacts) {
            this.setBooleanValue("buildRetention.deleteBuildArtifacts", deleteBuildArtifacts);
        }

        public Boolean isDeleteBuildArtifacts() {
            return this.getBooleanValue("buildRetention.deleteBuildArtifacts", true);
        }

        public void setBuildRetentionMaxDays(Integer daysToKeep) {
            this.setBuildRetentionDays(daysToKeep);
        }

        public Integer getBuildRetentionDays() {
            return this.getIntegerValue("buildRetention.daysToKeep");
        }

        public void setBuildRetentionDays(Integer daysToKeep) {
            this.setIntegerValue("buildRetention.daysToKeep", daysToKeep);
        }

        public Integer getBuildRetentionCount() {
            return this.getIntegerValue("buildRetention.count");
        }

        public void setBuildRetentionCount(Integer buildsToKeep) {
            this.setIntegerValue("buildRetention.count", buildsToKeep);
        }

        public String getBuildRetentionMinimumDate() {
            return this.getStringValue("buildRetention.minimumDate");
        }

        public void setBuildRetentionMinimumDate(String date) {
            this.setStringValue("buildRetention.minimumDate", date);
        }

        public String[] getBuildNumbersNotToDelete() {
            String value = this.getStringValue("buildRetention.buildNumbersNotToDelete");
            if (StringUtils.isNotBlank((String)value)) {
                return StringUtils.split((String)value, (String)",");
            }
            return new String[0];
        }

        public void setBuildNumbersNotToDelete(String buildNumbersNotToDelete) {
            this.setStringValue("buildRetention.buildNumbersNotToDelete", buildNumbersNotToDelete);
        }

        public String getReleaseComment() {
            return this.getStringValue("promotion.comment");
        }

        public void setReleaseComment(String comment) {
            this.setStringValue("promotion.comment", comment);
        }

        public void setReleaseEnabled(Boolean enabled) {
            this.setBooleanValue("promotion.enabled", enabled);
        }

        public Boolean isReleaseEnabled() {
            return this.getBooleanValue("promotion.enabled", false);
        }

        public String getBuildRoot() {
            return this.getStringValue("build.root");
        }

        public void setBuildRoot(String buildRoot) throws UnsupportedEncodingException {
            ArtifactoryClientConfiguration.this.publisher.setBuildRoot(buildRoot);
            ArtifactoryClientConfiguration.this.resolver.setBuildRoot(URLEncoder.encode(buildRoot, "UTF-8"));
            this.setStringValue("build.root", buildRoot);
        }

        public void setGeneratedBuildInfoFilePath(String generatedBuildInfo) {
            this.setStringValue("generated.build.info", generatedBuildInfo);
        }

        public String getGeneratedBuildInfoFilePath() {
            return this.getStringValue("generated.build.info");
        }

        public void addBuildVariables(Map<String, String> buildVariables, IncludeExcludePatterns patterns) {
            for (Map.Entry<String, String> entry : buildVariables.entrySet()) {
                String varKey = entry.getKey();
                if (PatternMatcher.pathConflicts(varKey, patterns)) continue;
                this.addEnvironmentProperty(varKey, entry.getValue());
            }
        }

        public void addEnvironmentProperty(String key, String value) {
            this.setStringValue("env." + key, value);
        }

        public void addRunParameters(String key, String value) {
            this.setStringValue("runParameters." + key, value);
        }

        public Map<String, String> getRunParameters() {
            Map tempMap = Maps.filterKeys((Map)this.props, this.buildRunParametersPredicate);
            HashMap runParameters = Maps.newHashMap();
            for (Map.Entry param : tempMap.entrySet()) {
                runParameters.put(((String)param.getKey()).replace("buildInfo.runParameters.", ""), param.getValue());
            }
            return runParameters;
        }

        public Boolean isIncremental() {
            return this.getBooleanValue("incremental", Boolean.FALSE);
        }

        public void setIncremental(Boolean incremental) {
            this.setBooleanValue("incremental", incremental);
        }
    }

    public class BlackDuckPropertiesHandler
    extends PrefixPropertyHandler {
        public BlackDuckPropertiesHandler() {
            super(ArtifactoryClientConfiguration.this.root, "buildInfo.governance.blackduck.");
        }

        public boolean isRunChecks() {
            return this.getBooleanValue("runChecks", false);
        }

        public void setRunChecks(boolean blackDuckRunChecks) {
            this.setBooleanValue("runChecks", blackDuckRunChecks);
        }

        public String getAppName() {
            return this.getStringValue("appName");
        }

        public void setAppName(String blackDuckAppName) {
            this.setStringValue("appName", blackDuckAppName);
        }

        public String getAppVersion() {
            return this.getStringValue("appVersion");
        }

        public void setAppVersion(String blackDuckAppVersion) {
            this.setStringValue("appVersion", blackDuckAppVersion);
        }

        public String getReportRecipients() {
            return this.getStringValue("reportRecipients");
        }

        public void setReportRecipients(String reportRecipients) {
            this.setStringValue("reportRecipients", reportRecipients);
        }

        public String getScopes() {
            return this.getStringValue("scopes");
        }

        public void setScopes(String scopes) {
            this.setStringValue("scopes", scopes);
        }

        public boolean isIncludePublishedArtifacts() {
            return this.getBooleanValue("includePublishedArtifacts", Boolean.TRUE);
        }

        public void setIncludePublishedArtifacts(boolean includePublishedArtifacts) {
            this.setBooleanValue("includePublishedArtifacts", includePublishedArtifacts);
        }

        public boolean isAutoCreateMissingComponentRequests() {
            return this.getBooleanValue("autoCreateMissingComponentRequests", Boolean.TRUE);
        }

        public void setAutoCreateMissingComponentRequests(boolean autoCreateMissingComponentRequests) {
            this.setBooleanValue("autoCreateMissingComponentRequests", autoCreateMissingComponentRequests);
        }

        public boolean isAutoDiscardStaleComponentRequests() {
            return this.getBooleanValue("autoDiscardStaleComponentRequests", Boolean.TRUE);
        }

        public void setAutoDiscardStaleComponentRequests(boolean autoDiscardStaleComponentRequests) {
            this.setBooleanValue("autoDiscardStaleComponentRequests", autoDiscardStaleComponentRequests);
        }

        public BlackDuckProperties copyBlackDuckProperties() {
            BlackDuckProperties blackDuckProperties = new BlackDuckProperties();
            blackDuckProperties.setRunChecks(this.isRunChecks());
            blackDuckProperties.setAppName(this.getAppName());
            blackDuckProperties.setAppVersion(this.getAppVersion());
            blackDuckProperties.setReportRecipients(this.getReportRecipients());
            blackDuckProperties.setScopes(this.getScopes());
            blackDuckProperties.setIncludePublishedArtifacts(this.isIncludePublishedArtifacts());
            blackDuckProperties.setAutoCreateMissingComponentRequests(this.isAutoCreateMissingComponentRequests());
            blackDuckProperties.setAutoDiscardStaleComponentRequests(this.isAutoDiscardStaleComponentRequests());
            return blackDuckProperties;
        }
    }

    public class IssuesTrackerHandler
    extends PrefixPropertyHandler {
        public IssuesTrackerHandler() {
            super(ArtifactoryClientConfiguration.this.root, "buildInfo.issues.");
        }

        public String getIssueTrackerName() {
            return this.getStringValue("tracker.name");
        }

        public void setIssueTrackerName(String issueTrackerName) {
            this.setStringValue("tracker.name", issueTrackerName);
        }

        public String getIssueTrackerVersion() {
            return this.getStringValue("tracker.version");
        }

        public void setIssueTrackerVersion(String issueTrackerVersion) {
            this.setStringValue("tracker.version", issueTrackerVersion);
        }

        public boolean getAggregateBuildIssues() {
            return this.getBooleanValue("aggregateBuildIssues", Boolean.FALSE);
        }

        public void setAggregateBuildIssues(boolean aggregateBuildIssues) {
            this.setBooleanValue("aggregateBuildIssues", aggregateBuildIssues);
        }

        public String getAggregationBuildStatus() {
            return this.getStringValue("aggregationBuildStatus");
        }

        public void setAggregationBuildStatus(String aggregationBuildStatus) {
            this.setStringValue("aggregationBuildStatus", aggregationBuildStatus);
        }

        public String getAffectedIssues() {
            return this.getStringValue("affectedIssues");
        }

        public void setAffectedIssues(String affectedIssues) {
            this.setStringValue("affectedIssues", affectedIssues);
        }

        public Set<Issue> getAffectedIssuesSet() {
            return IssuesTrackerUtils.getAffectedIssuesSet(this.getAffectedIssues());
        }
    }

    public class LicenseControlHandler
    extends PrefixPropertyHandler {
        public LicenseControlHandler() {
            super(ArtifactoryClientConfiguration.this.root, "buildInfo.licenseControl.");
        }

        public void setRunChecks(Boolean enabled) {
            this.setBooleanValue("runChecks", enabled);
        }

        public Boolean isRunChecks() {
            return this.getBooleanValue("runChecks", false);
        }

        public String getViolationRecipients() {
            return this.getStringValue("violationRecipients");
        }

        public void setViolationRecipients(String recipients) {
            this.setStringValue("violationRecipients", recipients);
        }

        public void setIncludePublishedArtifacts(Boolean enabled) {
            this.setBooleanValue("includePublishedArtifacts", enabled);
        }

        public Boolean isIncludePublishedArtifacts() {
            return this.getBooleanValue("includePublishedArtifacts", false);
        }

        public String getScopes() {
            return this.getStringValue("scopes");
        }

        public void setScopes(String scopes) {
            this.setStringValue("scopes", scopes);
        }

        public void setAutoDiscover(Boolean enabled) {
            this.setBooleanValue("autoDiscover", enabled);
        }

        public Boolean isAutoDiscover() {
            return this.getBooleanValue("autoDiscover", false);
        }
    }

    public abstract class RepositoryConfiguration
    extends AuthenticationConfiguration {
        private ImmutableMap<String, String> calculatedMatrixParams;

        protected RepositoryConfiguration(String prefix) {
            super(prefix);
        }

        public String getName() {
            return this.getStringValue("name");
        }

        public void setName(String name) {
            this.setStringValue("name", name);
        }

        public String urlWithMatrixParams(String rootUrl) {
            if (rootUrl == null) {
                return null;
            }
            rootUrl = StringUtils.stripEnd((String)rootUrl, (String)"/;");
            ImmutableMap<String, String> matrixParams = this.getMatrixParams();
            if (matrixParams.isEmpty()) {
                return rootUrl;
            }
            StringBuilder builder = new StringBuilder(rootUrl);
            for (Map.Entry entry : matrixParams.entrySet()) {
                builder.append(';').append((String)entry.getKey()).append('=').append((String)entry.getValue());
            }
            builder.append(';');
            return builder.toString();
        }

        public String getUrlWithMatrixParams() {
            return this.urlWithMatrixParams(this.getUrl());
        }

        public String getUrl() {
            String contextUrl;
            String repoKey;
            String value = this.getStringValue("url");
            if (StringUtils.isBlank((String)value) && StringUtils.isNotBlank((String)(repoKey = this.getRepoKey())) && StringUtils.isNotBlank((String)(contextUrl = this.getContextUrl()))) {
                contextUrl = StringUtils.stripEnd((String)contextUrl, (String)"/ ");
                return contextUrl + "/" + this.getRepoKey();
            }
            return StringUtils.removeEnd((String)value, (String)"/");
        }

        public void setUrl(String url) {
            this.setStringValue("url", url);
        }

        public String getUrl(String repo) {
            String contextUrl;
            String value = this.getStringValue("url");
            if (StringUtils.isBlank((String)value) && StringUtils.isNotBlank((String)repo) && StringUtils.isNotBlank((String)(contextUrl = this.getContextUrl()))) {
                contextUrl = StringUtils.stripEnd((String)contextUrl, (String)"/ ");
                return contextUrl + "/" + repo;
            }
            return StringUtils.removeEnd((String)value, (String)"/");
        }

        public String getRepoKey() {
            return this.getStringValue("repoKey");
        }

        public void setRepoKey(String repoKey) {
            this.setStringValue("repoKey", repoKey);
        }

        public void setMaven(boolean enabled) {
            this.setBooleanValue("maven", enabled);
        }

        public Boolean isMaven() {
            return this.getBooleanValue("maven", null);
        }

        public void setIvy(Boolean enabled) {
            this.setBooleanValue("ivy", enabled);
        }

        public Boolean isIvy() {
            return this.getBooleanValue("ivy", null);
        }

        public boolean isM2Compatible() {
            return this.getBooleanValue("ivy.m2compatible", true);
        }

        public void setM2Compatible(Boolean enabled) {
            this.setBooleanValue("ivy.m2compatible", enabled);
        }

        public String getIvyArtifactPattern() {
            String value = this.getStringValue("ivy.artPattern");
            if (StringUtils.isBlank((String)value)) {
                return "[organisation]/[module]/[revision]/[artifact]-[revision](-[classifier]).[ext]";
            }
            return value.trim();
        }

        public void setIvyArtifactPattern(String artPattern) {
            this.setStringValue("ivy.artPattern", artPattern);
        }

        public String getIvyPattern() {
            String value = this.getStringValue("ivy.ivyPattern");
            if (StringUtils.isBlank((String)value)) {
                return "[organisation]/[module]/ivy-[revision].xml";
            }
            return value.trim();
        }

        public void setIvyPattern(String ivyPattern) {
            this.setStringValue("ivy.ivyPattern", ivyPattern);
        }

        public abstract String getMatrixParamPrefix();

        public abstract String getContextUrl();

        public void addMatrixParam(String key, String value) {
            this.ensureImmutableMatrixParams();
            if (StringUtils.isBlank((String)key) || StringUtils.isBlank((String)value)) {
                return;
            }
            String matrixParamPrefix = this.getMatrixParamPrefix();
            if (key.startsWith(matrixParamPrefix)) {
                this.props.put(key, value);
            } else {
                this.props.put(matrixParamPrefix + key, value);
            }
        }

        public void addMatrixParams(Map<String, String> vars) {
            this.ensureImmutableMatrixParams();
            for (Map.Entry<String, String> entry : vars.entrySet()) {
                this.addMatrixParam(entry.getKey(), entry.getValue());
            }
        }

        public ImmutableMap<String, String> getMatrixParams() {
            if (this.calculatedMatrixParams != null) {
                return this.calculatedMatrixParams;
            }
            HashMap result = Maps.newHashMap();
            String matrixPrefix = this.getMatrixParamPrefix();
            for (Map.Entry entry : this.props.entrySet()) {
                if (!((String)entry.getKey()).startsWith(matrixPrefix)) continue;
                result.put(((String)entry.getKey()).substring(matrixPrefix.length()), entry.getValue());
            }
            this.calculatedMatrixParams = ImmutableMap.copyOf((Map)result);
            return this.calculatedMatrixParams;
        }

        private void ensureImmutableMatrixParams() {
            if (this.calculatedMatrixParams != null) {
                this.log.debug("Matrix params already set and cannot be modified");
            }
        }
    }

    public class AuthenticationConfiguration
    extends PrefixPropertyHandler {
        public AuthenticationConfiguration(String prefix) {
            super(ArtifactoryClientConfiguration.this.root, prefix);
        }

        public String getUsername() {
            return this.getStringValue("username");
        }

        public void setUsername(String userName) {
            this.setStringValue("username", userName);
        }

        public String getPassword() {
            return this.getStringValue("password");
        }

        public void setPassword(String password) {
            this.setStringValue("password", password);
        }
    }

    public class ProxyHandler
    extends AuthenticationConfiguration {
        public ProxyHandler() {
            super("artifactory.proxy.");
        }

        public String getHost() {
            return this.getStringValue("host");
        }

        public void setHost(String host) {
            this.setStringValue("host", host);
        }

        public Integer getPort() {
            return this.getIntegerValue("port");
        }

        public void setPort(Integer port) {
            this.setIntegerValue("port", port);
        }
    }

    public class PublisherHandler
    extends RepositoryConfiguration {
        public PublisherHandler() {
            super("artifactory.publish.");
        }

        @Override
        public String getContextUrl() {
            String contextUrl = this.getStringValue("contextUrl");
            if (StringUtils.isBlank((String)contextUrl)) {
                contextUrl = ArtifactoryClientConfiguration.this.getContextUrl();
            }
            return contextUrl;
        }

        public void setContextUrl(String contextUrl) {
            this.setStringValue("contextUrl", contextUrl);
        }

        public String getSnapshotRepoKey() {
            return this.getStringValue("snapshot.repoKey");
        }

        public void setSnapshotRepoKey(String repoKey) {
            this.setStringValue("snapshot.repoKey", repoKey);
        }

        public String getAggregateArtifacts() {
            return this.getStringValue("aggregate");
        }

        public void setAggregateArtifacts(String path) {
            this.setStringValue("aggregate", path);
        }

        public void setCopyAggregatedArtifacts(Boolean enabled) {
            this.setBooleanValue("copy.aggregated", enabled);
        }

        public void setPublishAggregatedArtifacts(Boolean enabled) {
            this.setBooleanValue("aggregated", enabled);
        }

        public Boolean isCopyAggregatedArtifacts() {
            return this.getBooleanValue("copy.aggregated", false);
        }

        public Boolean isPublishAggregatedArtifacts() {
            return this.getBooleanValue("aggregated", false);
        }

        public void setPublishArtifacts(Boolean enabled) {
            this.setBooleanValue("artifacts", enabled);
        }

        public Boolean isPublishArtifacts() {
            return this.getBooleanValue("artifacts", true);
        }

        public void setPublishBuildInfo(Boolean enabled) {
            this.setBooleanValue("buildInfo", enabled);
        }

        public Boolean isPublishBuildInfo() {
            return this.getBooleanValue("buildInfo", true);
        }

        public boolean isRecordAllDependencies() {
            return this.getBooleanValue("record.all.dependencies", false);
        }

        public void setRecordAllDependencies(Boolean enabled) {
            this.setBooleanValue("record.all.dependencies", enabled);
        }

        public String getIncludePatterns() {
            return this.getStringValue("includePatterns");
        }

        public void setIncludePatterns(String patterns) {
            this.setStringValue("includePatterns", patterns);
        }

        public boolean isFilterExcludedArtifactsFromBuild() {
            return this.getBooleanValue("filterExcludedArtifactsFromBuild", false);
        }

        public void setFilterExcludedArtifactsFromBuild(boolean excludeArtifactsFromBuild) {
            this.setBooleanValue("filterExcludedArtifactsFromBuild", excludeArtifactsFromBuild);
        }

        public String getExcludePatterns() {
            return this.getStringValue("excludePatterns");
        }

        public void setExcludePatterns(String patterns) {
            this.setStringValue("excludePatterns", patterns);
        }

        public void setEvenUnstable(Boolean enabled) {
            this.setBooleanValue("unstable", enabled);
        }

        public Boolean isEvenUnstable() {
            return this.getBooleanValue("unstable", false);
        }

        public String getBuildRoot() {
            return (String)this.getMatrixParams().get((Object)"build.root");
        }

        public void setBuildRoot(String buildRoot) {
            this.addMatrixParam("build.root", buildRoot);
        }

        @Override
        public String getMatrixParamPrefix() {
            return "artifactory.deploy.";
        }

        public ArtifactSpecs getArtifactSpecs() {
            String specs = this.getStringValue("artifactSpecs");
            return new ArtifactSpecs(specs);
        }

        public void setArtifactSpecs(String artifactSpecs) {
            this.setStringValue("artifactSpecs", artifactSpecs);
        }
    }

    public class ResolverHandler
    extends RepositoryConfiguration {
        public ResolverHandler() {
            super("artifactory.resolve.");
        }

        public String getDownloadUrl() {
            return ArtifactoryClientConfiguration.this.root.getStringValue("artifactory.downloadUrl");
        }

        @Override
        public String getContextUrl() {
            String contextUrl = this.getStringValue("contextUrl");
            if (StringUtils.isBlank((String)contextUrl)) {
                contextUrl = ArtifactoryClientConfiguration.this.getContextUrl();
            }
            return contextUrl;
        }

        public void setContextUrl(String contextUrl) {
            this.setStringValue("contextUrl", contextUrl);
        }

        public boolean isIvyRepositoryDefined() {
            return ArtifactoryClientConfiguration.this.root.getBooleanValue("ivy.repo.defined", false);
        }

        public void setIvyRepositoryDefined(boolean ivyRepositoryDefined) {
            ArtifactoryClientConfiguration.this.root.setBooleanValue("ivy.repo.defined", ivyRepositoryDefined);
        }

        public String getBuildRoot() {
            return (String)this.getMatrixParams().get((Object)"build.root");
        }

        public void setBuildRoot(String buildRoot) {
            this.addMatrixParam("build.root", buildRoot);
        }

        @Override
        public String getMatrixParamPrefix() {
            return this.getPrefix() + "matrix";
        }

        public String getDownloadSnapshotRepoKey() {
            return this.getStringValue("downSnapshotRepoKey");
        }

        public void setDownloadSnapshotRepoKey(String repoKey) {
            this.setStringValue("downSnapshotRepoKey", repoKey);
        }
    }
}

