/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.build.extractor.clientConfiguration.util;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.lang.StringUtils;

public class FileCollectionUtil {
    public static List<String> collectFiles(String baseDir, String fixedPattern, boolean isRecursive, boolean regexp) {
        File[] filesToScan = new File(baseDir).listFiles();
        ArrayList<String> results = new ArrayList<String>();
        if (filesToScan != null) {
            for (File file : filesToScan) {
                if (file.isFile()) {
                    results.add(file.getAbsolutePath().replace("\\", "/"));
                    FileCollectionUtil.isPassedLimit(results.size());
                    continue;
                }
                if (isRecursive) {
                    results.addAll(FileCollectionUtil.collectFiles(file.getAbsolutePath(), -1, results.size()));
                    continue;
                }
                if (regexp) continue;
                int numberOfSeparators = StringUtils.countMatches((String)fixedPattern, (String)"/") + StringUtils.countMatches((String)baseDir, (String)"/");
                results.addAll(FileCollectionUtil.collectFiles(file.getAbsolutePath(), numberOfSeparators, results.size()));
            }
        }
        return results;
    }

    private static List<String> collectFiles(String dir, int depth, int numberOfCandidates) {
        ArrayList<String> result = new ArrayList<String>();
        LinkedList<String> foldersToScan = new LinkedList<String>();
        foldersToScan.add(dir);
        for (int i = 0; i < foldersToScan.size(); ++i) {
            String folderString = (String)foldersToScan.get(i);
            if (depth != -1 && StringUtils.countMatches((String)folderString, (String)File.separator) > depth) continue;
            File file = new File(folderString);
            ArrayList<File> folderContent = new ArrayList<File>();
            if (file.listFiles() != null) {
                folderContent.addAll(Arrays.asList(file.listFiles()));
            }
            if (folderContent.isEmpty()) continue;
            for (File entry : folderContent) {
                if (entry.isDirectory()) {
                    foldersToScan.add(entry.getAbsolutePath());
                    continue;
                }
                if (depth != -1 && StringUtils.countMatches((String)entry.getPath(), (String)File.separator) != depth) continue;
                result.add(entry.getAbsolutePath().replace("\\", "/"));
                FileCollectionUtil.isPassedLimit(numberOfCandidates + result.size());
            }
        }
        return result;
    }

    private static void isPassedLimit(int numberOfFiles) {
        int limit = 1000000;
        if (numberOfFiles >= limit) {
            throw new IllegalStateException("Too many candidate files found.");
        }
    }
}

