/*
 * Decompiled with CFR 0.152.
 */
package org.jgrapht.alg.shortestpath;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import org.jgrapht.Graph;
import org.jgrapht.Graphs;
import org.jgrapht.alg.interfaces.ShortestPathAlgorithm;
import org.jgrapht.alg.shortestpath.TreeSingleSourcePathsImpl;
import org.jgrapht.alg.util.Pair;
import org.jgrapht.util.FibonacciHeap;
import org.jgrapht.util.FibonacciHeapNode;

class DijkstraClosestFirstIterator<V, E>
implements Iterator<V> {
    private final Graph<V, E> graph;
    private final V source;
    private final double radius;
    private final FibonacciHeap<QueueEntry> heap;
    private final Map<V, FibonacciHeapNode<QueueEntry>> seen;

    public DijkstraClosestFirstIterator(Graph<V, E> graph, V source) {
        this(graph, source, Double.POSITIVE_INFINITY);
    }

    public DijkstraClosestFirstIterator(Graph<V, E> graph, V source, double radius) {
        this.graph = Objects.requireNonNull(graph, "Graph cannot be null");
        this.source = Objects.requireNonNull(source, "Sourve vertex cannot be null");
        if (radius < 0.0) {
            throw new IllegalArgumentException("Radius must be non-negative");
        }
        this.radius = radius;
        this.heap = new FibonacciHeap();
        this.seen = new HashMap<V, FibonacciHeapNode<QueueEntry>>();
        this.updateDistance(source, null, 0.0);
    }

    @Override
    public boolean hasNext() {
        if (this.heap.isEmpty()) {
            return false;
        }
        FibonacciHeapNode<QueueEntry> vNode = this.heap.min();
        double vDistance = vNode.getKey();
        if (this.radius < vDistance) {
            this.heap.clear();
            return false;
        }
        return true;
    }

    @Override
    public V next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        FibonacciHeapNode<QueueEntry> vNode = this.heap.removeMin();
        Object v = vNode.getData().v;
        double vDistance = vNode.getKey();
        for (E e : this.graph.outgoingEdgesOf(v)) {
            V u = Graphs.getOppositeVertex(this.graph, e, v);
            double eWeight = this.graph.getEdgeWeight(e);
            if (eWeight < 0.0) {
                throw new IllegalArgumentException("Negative edge weight not allowed");
            }
            this.updateDistance(u, e, vDistance + eWeight);
        }
        return v;
    }

    public ShortestPathAlgorithm.SingleSourcePaths<V, E> getPaths() {
        return new TreeSingleSourcePathsImpl<V, E>(this.graph, this.source, this.getDistanceAndPredecessorMap());
    }

    public Map<V, Pair<Double, E>> getDistanceAndPredecessorMap() {
        HashMap distanceAndPredecessorMap = new HashMap();
        for (FibonacciHeapNode<QueueEntry> vNode : this.seen.values()) {
            double vDistance = vNode.getKey();
            if (this.radius < vDistance) continue;
            Object v = vNode.getData().v;
            distanceAndPredecessorMap.put(v, Pair.of(vDistance, vNode.getData().e));
        }
        return distanceAndPredecessorMap;
    }

    private void updateDistance(V v, E e, double distance) {
        FibonacciHeapNode<QueueEntry> node = this.seen.get(v);
        if (node == null) {
            node = new FibonacciHeapNode<QueueEntry>(new QueueEntry(e, v));
            this.heap.insert(node, distance);
            this.seen.put((FibonacciHeapNode<QueueEntry>)v, node);
        } else if (distance < node.getKey()) {
            this.heap.decreaseKey(node, distance);
            node.getData().e = e;
        }
    }

    class QueueEntry {
        E e;
        V v;

        public QueueEntry(E e, V v) {
            this.e = e;
            this.v = v;
        }
    }
}

