/*
 * Decompiled with CFR 0.152.
 */
package org.jgrapht.alg.spanning;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Objects;
import org.jgrapht.Graph;
import org.jgrapht.Graphs;
import org.jgrapht.alg.interfaces.SpanningTreeAlgorithm;
import org.jgrapht.util.FibonacciHeap;
import org.jgrapht.util.FibonacciHeapNode;

public class PrimMinimumSpanningTree<V, E>
implements SpanningTreeAlgorithm<E> {
    private final Graph<V, E> g;

    public PrimMinimumSpanningTree(Graph<V, E> graph) {
        this.g = Objects.requireNonNull(graph, "Graph cannot be null");
    }

    @Override
    public SpanningTreeAlgorithm.SpanningTree<E> getSpanningTree() {
        HashSet minimumSpanningTreeEdgeSet = new HashSet(this.g.vertexSet().size());
        double spanningTreeWeight = 0.0;
        int N = this.g.vertexSet().size();
        HashMap<V, Integer> vertexMap = new HashMap<V, Integer>();
        ArrayList<V> indexList = new ArrayList<V>();
        for (V v : this.g.vertexSet()) {
            vertexMap.put(v, vertexMap.size());
            indexList.add(v);
        }
        VertexInfo[] vertices = (VertexInfo[])Array.newInstance(VertexInfo.class, N);
        FibonacciHeapNode[] fibNodes = (FibonacciHeapNode[])Array.newInstance(FibonacciHeapNode.class, N);
        FibonacciHeap fibonacciHeap = new FibonacciHeap();
        for (int i = 0; i < N; ++i) {
            vertices[i] = new VertexInfo();
            vertices[i].id = i;
            vertices[i].distance = Double.MAX_VALUE;
            fibNodes[i] = new FibonacciHeapNode<VertexInfo>(vertices[i]);
            fibonacciHeap.insert(fibNodes[i], vertices[i].distance);
        }
        while (!fibonacciHeap.isEmpty()) {
            FibonacciHeapNode fibNode = fibonacciHeap.removeMin();
            VertexInfo vertexInfo = (VertexInfo)fibNode.getData();
            Object p = indexList.get(vertexInfo.id);
            vertexInfo.spanned = true;
            if (vertexInfo.edgeFromParent != null) {
                minimumSpanningTreeEdgeSet.add(vertexInfo.edgeFromParent);
                spanningTreeWeight += this.g.getEdgeWeight(vertexInfo.edgeFromParent);
            }
            for (E e : this.g.edgesOf(p)) {
                double cost;
                V q = Graphs.getOppositeVertex(this.g, e, p);
                int id = (Integer)vertexMap.get(q);
                if (vertices[id].spanned || !((cost = this.g.getEdgeWeight(e)) < vertices[id].distance)) continue;
                vertices[id].distance = cost;
                vertices[id].edgeFromParent = e;
                fibonacciHeap.decreaseKey(fibNodes[id], cost);
            }
        }
        return new SpanningTreeAlgorithm.SpanningTreeImpl(minimumSpanningTreeEdgeSet, spanningTreeWeight);
    }

    private class VertexInfo {
        public int id;
        public boolean spanned;
        public double distance;
        public E edgeFromParent;

        private VertexInfo() {
        }
    }
}

