/*
 * Decompiled with CFR 0.152.
 */
package org.jmock.lib.legacy;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.List;
import net.sf.cglib.core.CodeGenerationException;
import net.sf.cglib.core.DefaultNamingPolicy;
import net.sf.cglib.core.NamingPolicy;
import net.sf.cglib.core.Predicate;
import net.sf.cglib.proxy.Callback;
import net.sf.cglib.proxy.CallbackFilter;
import net.sf.cglib.proxy.Enhancer;
import net.sf.cglib.proxy.Factory;
import net.sf.cglib.proxy.InvocationHandler;
import net.sf.cglib.proxy.NoOp;
import org.jmock.api.Imposteriser;
import org.jmock.api.Invocation;
import org.jmock.api.Invokable;
import org.jmock.internal.SearchingClassLoader;
import org.objenesis.Objenesis;
import org.objenesis.ObjenesisStd;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClassImposteriser
implements Imposteriser {
    public static final Imposteriser INSTANCE = new ClassImposteriser();
    private static final NamingPolicy NAMING_POLICY_THAT_ALLOWS_IMPOSTERISATION_OF_CLASSES_IN_SIGNED_PACKAGES = new DefaultNamingPolicy(){

        public String getClassName(String prefix, String source, Object key, Predicate names) {
            return "org.jmock.codegen." + super.getClassName(prefix, source, key, names);
        }
    };
    private static final CallbackFilter IGNORE_BRIDGE_METHODS = new CallbackFilter(){

        public int accept(Method method) {
            return method.isBridge() ? 1 : 0;
        }
    };
    private final Objenesis objenesis = new ObjenesisStd();

    private ClassImposteriser() {
    }

    public boolean canImposterise(Class<?> type) {
        return !type.isPrimitive() && !Modifier.isFinal(type.getModifiers()) && (type.isInterface() || !this.toStringMethodIsFinal(type));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T imposterise(Invokable mockObject, Class<T> mockedType, Class<?> ... ancilliaryTypes) {
        if (!mockedType.isInterface() && this.toStringMethodIsFinal(mockedType)) {
            throw new IllegalArgumentException(mockedType.getName() + " has a final toString method");
        }
        try {
            this.setConstructorsAccessible(mockedType, true);
            T t = mockedType.cast(this.proxy(this.proxyClass(mockedType, ancilliaryTypes), mockObject));
            return t;
        }
        finally {
            this.setConstructorsAccessible(mockedType, false);
        }
    }

    private boolean toStringMethodIsFinal(Class<?> type) {
        try {
            Method toString = type.getMethod("toString", new Class[0]);
            return Modifier.isFinal(toString.getModifiers());
        }
        catch (SecurityException e) {
            throw new IllegalStateException("not allowed to reflect on toString method", e);
        }
        catch (NoSuchMethodException e) {
            throw new Error("no public toString method found", e);
        }
    }

    private void setConstructorsAccessible(Class<?> mockedType, boolean accessible) {
        for (Constructor<?> constructor : mockedType.getDeclaredConstructors()) {
            constructor.setAccessible(accessible);
        }
    }

    private Class<?> proxyClass(Class<?> possibleMockedType, Class<?> ... ancilliaryTypes) {
        Class mockedType = possibleMockedType == Object.class ? ClassWithSuperclassToWorkAroundCglibBug.class : possibleMockedType;
        Enhancer enhancer = new Enhancer(){

            protected void filterConstructors(Class sc, List constructors) {
            }
        };
        enhancer.setClassLoader(SearchingClassLoader.combineLoadersOf(mockedType, (Class[])ancilliaryTypes));
        enhancer.setUseFactory(true);
        if (mockedType.isInterface()) {
            enhancer.setSuperclass(Object.class);
            enhancer.setInterfaces((Class[])this.prepend(mockedType, ancilliaryTypes));
        } else {
            enhancer.setSuperclass(mockedType);
            enhancer.setInterfaces((Class[])ancilliaryTypes);
        }
        enhancer.setCallbackTypes(new Class[]{InvocationHandler.class, NoOp.class});
        enhancer.setCallbackFilter(IGNORE_BRIDGE_METHODS);
        if (mockedType.getSigners() != null) {
            enhancer.setNamingPolicy(NAMING_POLICY_THAT_ALLOWS_IMPOSTERISATION_OF_CLASSES_IN_SIGNED_PACKAGES);
        }
        try {
            return enhancer.createClass();
        }
        catch (CodeGenerationException e) {
            throw new IllegalArgumentException("could not imposterise " + mockedType, e);
        }
    }

    private Object proxy(Class<?> proxyClass, final Invokable mockObject) {
        Factory proxy = (Factory)this.objenesis.newInstance(proxyClass);
        proxy.setCallbacks(new Callback[]{new InvocationHandler(){

            public Object invoke(Object receiver, Method method, Object[] args) throws Throwable {
                return mockObject.invoke(new Invocation(receiver, method, args));
            }
        }, NoOp.INSTANCE});
        return proxy;
    }

    private Class<?>[] prepend(Class<?> first, Class<?> ... rest) {
        Class[] all = new Class[rest.length + 1];
        all[0] = first;
        System.arraycopy(rest, 0, all, 1, rest.length);
        return all;
    }

    public static class ClassWithSuperclassToWorkAroundCglibBug {
    }
}

