/*
 * Decompiled with CFR 0.152.
 */
package org.jmolecules.annotation.processor.aptk.templating.expressions.operands;

import org.jmolecules.annotation.processor.aptk.templating.expressions.Expression;
import org.jmolecules.annotation.processor.aptk.templating.expressions.operands.BooleanOperand;
import org.jmolecules.annotation.processor.aptk.templating.expressions.operands.DoubleOperand;
import org.jmolecules.annotation.processor.aptk.templating.expressions.operands.DynamicOperand;
import org.jmolecules.annotation.processor.aptk.templating.expressions.operands.ExpressionOperand;
import org.jmolecules.annotation.processor.aptk.templating.expressions.operands.LongOperand;
import org.jmolecules.annotation.processor.aptk.templating.expressions.operands.NullValueOperand;
import org.jmolecules.annotation.processor.aptk.templating.expressions.operands.Operand;
import org.jmolecules.annotation.processor.aptk.templating.expressions.operands.OperandType;
import org.jmolecules.annotation.processor.aptk.templating.expressions.operands.OperationResultOperand;
import org.jmolecules.annotation.processor.aptk.templating.expressions.operands.StringOperand;
import org.jmolecules.annotation.processor.aptk.templating.expressions.operands.UnaryOperationWrapperOperand;
import org.jmolecules.annotation.processor.aptk.templating.expressions.operations.OperationType;

public class OperandFactory {
    private OperandFactory() {
    }

    public static Operand createOperand(OperandType operandType, String expressionString, OperationType[] unaryOperationsToBeApplied, Expression expression) {
        if (operandType == null || expressionString == null) {
            throw new IllegalArgumentException("operandType and expressionString must not be null");
        }
        Operand operand = null;
        switch (operandType) {
            case BOOLEAN: {
                operand = new BooleanOperand(expressionString);
                break;
            }
            case LONG: {
                operand = new LongOperand(expressionString);
                break;
            }
            case DOUBLE: {
                operand = new DoubleOperand(expressionString);
                break;
            }
            case STRING: {
                operand = new StringOperand(expressionString);
                break;
            }
            case DYNAMIC_VALUE: {
                operand = new DynamicOperand(expressionString);
                break;
            }
            case EXPRESSION: {
                operand = new ExpressionOperand(expressionString, expression);
                break;
            }
            case NULL_VALUE: {
                operand = new NullValueOperand(expressionString);
                break;
            }
            default: {
                throw new IllegalArgumentException("operandType " + (Object)((Object)operandType) + " currently not implemented");
            }
        }
        if (unaryOperationsToBeApplied != null && unaryOperationsToBeApplied.length >= 1) {
            for (int i = unaryOperationsToBeApplied.length - 1; i >= 0; --i) {
                operand = OperandFactory.createUnaryOperand(operand, unaryOperationsToBeApplied[i]);
            }
        }
        return operand;
    }

    public static OperationResultOperand createOperationResult(Class type, Object value) {
        return new OperationResultOperand(type, value);
    }

    public static UnaryOperationWrapperOperand createUnaryOperand(Operand operand, OperationType operationType) {
        return new UnaryOperationWrapperOperand(operand, operationType);
    }
}

