/*
 * Decompiled with CFR 0.152.
 */
package org.jmolecules.annotation.processor.aptk.templating.expressions.operands;

import java.util.regex.Matcher;
import org.jmolecules.annotation.processor.aptk.templating.expressions.operands.OperandType;
import org.jmolecules.annotation.processor.aptk.templating.expressions.operands.ParsedOperand;

public class StringOperand
extends ParsedOperand<String> {
    private final String internalValue;

    public StringOperand(String expressionString) {
        super(expressionString);
        Matcher matcher = this.getOperandType().getOperandPattern().matcher(expressionString);
        if (matcher.find()) {
            String tempValue = matcher.group(1);
            tempValue = tempValue.replaceAll("\\\\[']", "'");
            this.internalValue = tempValue = tempValue.replaceAll("\\\\", "\\");
        } else {
            this.internalValue = null;
        }
    }

    @Override
    public Class<String> getOperandsJavaType() {
        return String.class;
    }

    @Override
    public String value() {
        return this.internalValue;
    }

    @Override
    public OperandType getOperandType() {
        return OperandType.STRING;
    }
}

