/*
 * Decompiled with CFR 0.152.
 */
package org.jmolecules.annotation.processor.aptk.tools;

import java.lang.annotation.Annotation;
import java.lang.annotation.Repeatable;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.Filer;
import javax.annotation.processing.Messager;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.RoundEnvironment;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;
import org.jmolecules.annotation.processor.aptk.common.ToolingProvider;
import org.jmolecules.annotation.processor.aptk.tools.AnnotationUtils;
import org.jmolecules.annotation.processor.aptk.tools.ProcessingEnvironmentUtils;

public abstract class AbstractAnnotationProcessor
extends AbstractProcessor {
    @Override
    public synchronized void init(ProcessingEnvironment processingEnv) {
        super.init(processingEnv);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        try {
            ToolingProvider.setTooling(this.processingEnv);
            boolean bl = this.processAnnotations(annotations, roundEnv);
            return bl;
        }
        finally {
            ToolingProvider.clearTooling();
        }
    }

    public abstract boolean processAnnotations(Set<? extends TypeElement> var1, RoundEnvironment var2);

    @Override
    public SourceVersion getSupportedSourceVersion() {
        return SourceVersion.latestSupported();
    }

    public static Elements getElements() {
        return ProcessingEnvironmentUtils.getElements();
    }

    public static Filer getFiler() {
        return ProcessingEnvironmentUtils.getFiler();
    }

    public static Types getTypes() {
        return ProcessingEnvironmentUtils.getTypes();
    }

    public static Messager getMessager() {
        return ProcessingEnvironmentUtils.getMessager();
    }

    @SafeVarargs
    protected static Set<String> createSupportedAnnotationSet(Class<? extends Annotation> ... annotationTypes) {
        HashSet<String> result = new HashSet<String>();
        if (annotationTypes != null) {
            for (Class<? extends Annotation> annotationType : annotationTypes) {
                if (annotationType == null) continue;
                result.add(annotationType.getCanonicalName());
                Repeatable repeatableAnnotation = annotationType.getAnnotation(Repeatable.class);
                if (repeatableAnnotation == null) continue;
                result.add(repeatableAnnotation.value().getCanonicalName());
            }
        }
        return result;
    }

    public static Set<Element> getAnnotatedElements(RoundEnvironment roundEnvironment, Class<? extends Annotation> annotation) {
        HashSet<Element> result = new HashSet<Element>(roundEnvironment.getElementsAnnotatedWith(annotation));
        Optional<Class<? extends Annotation>> wrapperAnnotationType = AnnotationUtils.getRepeatableAnnotationWrapperClass(annotation);
        if (AnnotationUtils.isRepeatableAnnotation(annotation)) {
            result.addAll(roundEnvironment.getElementsAnnotatedWith(wrapperAnnotationType.get()));
        }
        return result;
    }

    @SafeVarargs
    public static <T> T[] wrapToArray(T ... element) {
        return element;
    }
}

