/*
 * Decompiled with CFR 0.152.
 */
package org.jmolecules.annotation.processor.aptk.tools;

import java.io.IOException;
import javax.lang.model.element.Element;
import javax.tools.StandardLocation;
import org.jmolecules.annotation.processor.aptk.tools.ProcessingEnvironmentUtils;
import org.jmolecules.annotation.processor.aptk.tools.generators.SimpleJavaWriter;
import org.jmolecules.annotation.processor.aptk.tools.generators.SimpleKotlinWriter;
import org.jmolecules.annotation.processor.aptk.tools.generators.SimpleResourceReader;
import org.jmolecules.annotation.processor.aptk.tools.generators.SimpleResourceWriter;

public final class FilerUtils {
    private FilerUtils() {
    }

    public static SimpleResourceReader getResource(String fileName, String targetPackage) throws IOException {
        return FilerUtils.getResource(StandardLocation.SOURCE_OUTPUT, targetPackage, fileName);
    }

    public static SimpleResourceReader getResource(StandardLocation standardLocation, String targetPackage, String fileName) throws IOException {
        return new SimpleResourceReader(ProcessingEnvironmentUtils.getFiler().getResource(standardLocation, targetPackage != null ? targetPackage : "", fileName));
    }

    public static SimpleResourceReader getResource(String fileName) throws IOException {
        return FilerUtils.getResource("", fileName);
    }

    public static SimpleResourceWriter createResource(String targetPackage, String fileName, Element ... originatingElements) throws IOException {
        return FilerUtils.createResource(StandardLocation.CLASS_OUTPUT, targetPackage, fileName, new Element[0]);
    }

    public static SimpleResourceWriter createResource(StandardLocation location, String targetPackage, String fileName, Element ... originatingElements) throws IOException {
        return new SimpleResourceWriter(ProcessingEnvironmentUtils.getFiler().createResource(location, targetPackage != null ? targetPackage : "", fileName, originatingElements));
    }

    public static SimpleResourceWriter createResource(String fileName) throws IOException {
        return FilerUtils.createResource("", fileName, new Element[0]);
    }

    public static SimpleJavaWriter createClassFile(String fileName, Element ... originatingElements) throws IOException {
        return new SimpleJavaWriter(ProcessingEnvironmentUtils.getFiler().createClassFile(fileName, originatingElements));
    }

    public static SimpleJavaWriter createSourceFile(String fileName, Element ... originatingElements) throws IOException {
        return new SimpleJavaWriter(ProcessingEnvironmentUtils.getFiler().createSourceFile(fileName, originatingElements));
    }

    public static SimpleKotlinWriter createKotlinSourceFile(String fileName, Element ... originatingElements) throws IOException {
        return new SimpleKotlinWriter(fileName, originatingElements);
    }
}

