/*
 * Decompiled with CFR 0.152.
 */
package org.jmolecules.annotation.processor.aptk.tools.generators;

import java.io.BufferedReader;
import java.io.CharArrayWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import javax.tools.FileObject;

public class SimpleResourceReader
implements AutoCloseable {
    private final FileObject fileObject;
    private final BufferedReader foReader;

    public SimpleResourceReader(FileObject fileObject) throws IOException {
        this.fileObject = fileObject;
        this.foReader = new BufferedReader(fileObject.openReader(true));
    }

    public String readLine() throws IOException {
        return this.foReader.readLine();
    }

    public String readAsString() throws IOException {
        char[] buffer = new char[10000];
        CharArrayWriter writer = new CharArrayWriter();
        int line = 0;
        while ((line = this.foReader.read(buffer)) != -1) {
            writer.write(buffer, 0, line);
        }
        this.foReader.close();
        writer.flush();
        writer.close();
        return writer.toString();
    }

    public List<String> readAsLines() throws IOException {
        return this.readAsLines(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> readAsLines(boolean trimLines) throws IOException {
        ArrayList<String> result = new ArrayList<String>();
        try {
            String line = this.foReader.readLine();
            while (line != null) {
                result.add(trimLines ? line.trim() : line);
                line = this.foReader.readLine();
            }
        }
        finally {
            this.foReader.close();
        }
        return result;
    }

    public Properties readAsProperties() throws IOException {
        Properties properties = new Properties();
        try {
            properties.load(this.foReader);
        }
        finally {
            this.foReader.close();
        }
        return properties;
    }

    @Override
    public void close() throws IOException {
        this.foReader.close();
    }
}

