/*
 * Decompiled with CFR 0.152.
 */
package org.jmolecules.bytebuddy;

import java.io.IOException;
import java.lang.annotation.Annotation;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import net.bytebuddy.build.Plugin;
import net.bytebuddy.description.type.TypeDefinition;
import net.bytebuddy.description.type.TypeDescription;
import net.bytebuddy.dynamic.ClassFileLocator;
import net.bytebuddy.dynamic.DynamicType;
import org.jmolecules.bytebuddy.PluginUtils;
import org.jmolecules.ddd.annotation.Repository;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.repository.RepositoryDefinition;

public class JMoleculesSpringDataPlugin
implements Plugin {
    private static final Logger log = LoggerFactory.getLogger(JMoleculesSpringDataPlugin.class);
    private static final Class<?> SPRING_DATA_REPOSITORY = org.springframework.data.repository.Repository.class;
    private static final Class<?> JMOLECULES_REPOSITORY = org.jmolecules.ddd.types.Repository.class;
    private static final Map<Class<?>, Class<? extends Annotation>> TYPES;

    public boolean matches(TypeDescription target) {
        return target.isAssignableTo(JMOLECULES_REPOSITORY) || TYPES.keySet().stream().anyMatch(it -> it.isAnnotation() ? PluginUtils.isAnnotatedWith(target, it) : target.isAssignableTo(it));
    }

    public DynamicType.Builder<?> apply(DynamicType.Builder<?> builder, TypeDescription typeDescription, ClassFileLocator classFileLocator) {
        if (!typeDescription.isAssignableTo(SPRING_DATA_REPOSITORY)) {
            builder = JMoleculesSpringDataPlugin.translateRepositoryInterfaces(builder, typeDescription, typeDescription.asGenericType());
        }
        return PluginUtils.mapAnnotationOrInterfaces("jMolecules Spring Data", builder, typeDescription, TYPES);
    }

    public void close() throws IOException {
    }

    private static DynamicType.Builder<?> translateRepositoryInterfaces(DynamicType.Builder<?> builder, TypeDescription original, TypeDescription.Generic type) {
        if (type.asErasure().represents(JMOLECULES_REPOSITORY)) {
            try {
                TypeDescription.Generic aggregateType = (TypeDescription.Generic)type.getTypeArguments().get(0);
                TypeDescription.Generic idType = (TypeDescription.Generic)type.getTypeArguments().get(1);
                TypeDescription.ForLoadedType loadedType = new TypeDescription.ForLoadedType(SPRING_DATA_REPOSITORY);
                TypeDescription.Generic repositoryType = TypeDescription.Generic.Builder.parameterizedType((TypeDescription)loadedType, (TypeDefinition[])new TypeDefinition[]{aggregateType, idType}).build();
                log.info("jMolecules Spring Data - {} - Implement {}<{}, {}>.", new Object[]{original.getSimpleName(), repositoryType.asErasure().getName(), aggregateType.asErasure().getSimpleName(), idType.asErasure().getSimpleName()});
                return builder.implement(new TypeDefinition[]{repositoryType});
            }
            catch (Exception o_O) {
                log.info("jMolecules Spring Data - {} - No generics declared. Cannot translate into Spring Data repository!", (Object)original.getSimpleName());
                return builder;
            }
        }
        if (type.isInterface()) {
            for (TypeDescription.Generic parent : type.getInterfaces()) {
                builder = JMoleculesSpringDataPlugin.translateRepositoryInterfaces(builder, original, parent);
            }
        }
        return builder;
    }

    static {
        HashMap<Class, Class<Repository>> types = new HashMap<Class, Class<Repository>>();
        types.put(RepositoryDefinition.class, Repository.class);
        types.put(org.springframework.data.repository.Repository.class, Repository.class);
        TYPES = Collections.unmodifiableMap(types);
    }
}

