/*
 * Decompiled with CFR 0.152.
 */
package org.jmolecules.bytebuddy;

import java.io.IOException;
import java.lang.reflect.Constructor;
import java.util.List;
import java.util.stream.Collectors;
import javax.persistence.Convert;
import net.bytebuddy.ByteBuddy;
import net.bytebuddy.ClassFileVersion;
import net.bytebuddy.build.Plugin;
import net.bytebuddy.description.annotation.AnnotationDescription;
import net.bytebuddy.description.field.FieldDescription;
import net.bytebuddy.description.modifier.ModifierContributor;
import net.bytebuddy.description.modifier.Visibility;
import net.bytebuddy.description.type.TypeDefinition;
import net.bytebuddy.description.type.TypeDescription;
import net.bytebuddy.description.type.TypeList;
import net.bytebuddy.dynamic.ClassFileLocator;
import net.bytebuddy.dynamic.DynamicType;
import net.bytebuddy.implementation.Implementation;
import net.bytebuddy.implementation.MethodCall;
import net.bytebuddy.matcher.ElementMatcher;
import net.bytebuddy.matcher.ElementMatchers;
import org.jmolecules.bytebuddy.JMoleculesType;
import org.jmolecules.bytebuddy.PluginLogger;
import org.jmolecules.bytebuddy.PluginUtils;
import org.jmolecules.ddd.types.Association;
import org.jmolecules.ddd.types.Entity;
import org.jmolecules.spring.jpa.AssociationAttributeConverter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JMoleculesSpringJpaPlugin
implements Plugin {
    private static final Logger log = LoggerFactory.getLogger(JMoleculesSpringJpaPlugin.class);
    private static PluginLogger logger = new PluginLogger("Spring JPA");

    public boolean matches(TypeDescription target) {
        return target.getDeclaredAnnotations().isAnnotationPresent(org.jmolecules.ddd.annotation.Entity.class) || target.isAssignableTo(Entity.class);
    }

    public DynamicType.Builder<?> apply(DynamicType.Builder<?> builder, TypeDescription typeDescription, ClassFileLocator classFileLocator) {
        return JMoleculesType.of(logger, builder).map((it, log) -> {
            List associationFields = builder.toTypeDescription().getDeclaredFields().stream().filter(field -> field.getType().asErasure().represents(Association.class)).collect(Collectors.toList());
            for (FieldDescription.InDefinedShape field2 : associationFields) {
                if (field2.getDeclaredAnnotations().isAnnotationPresent(Convert.class)) {
                    log.info("jMolecules Spring JPA - {}.{} - Found existing converter registration.", field2.getDeclaringType().getSimpleName(), field2.getName());
                    continue;
                }
                it = JMoleculesSpringJpaPlugin.createConvertAnnotation(field2, it);
            }
            return it;
        }).conclude();
    }

    public void close() throws IOException {
    }

    private static DynamicType.Builder<?> createConvertAnnotation(FieldDescription.InDefinedShape field, DynamicType.Builder<?> builder) {
        TypeList.Generic generic = field.getType().asGenericType().getTypeArguments();
        TypeDescription.Generic aggregateType = (TypeDescription.Generic)generic.get(0);
        TypeDescription.Generic idType = (TypeDescription.Generic)generic.get(1);
        TypeDescription.Generic idPrimitiveType = JMoleculesSpringJpaPlugin.getIdPrimitiveType(idType);
        if (idPrimitiveType == null) {
            log.info("jMolecules Spring JPA - {}.{} - Unable to detect id primitive in {}.", new Object[]{PluginUtils.abbreviate((TypeDefinition)field.getDeclaringType()), field.getName(), PluginUtils.abbreviate((TypeDefinition)idType)});
            return builder;
        }
        TypeDescription.ForLoadedType loadedType = new TypeDescription.ForLoadedType(AssociationAttributeConverter.class);
        TypeDescription.Generic superType = TypeDescription.Generic.Builder.parameterizedType((TypeDescription)loadedType, (TypeDefinition[])new TypeDefinition[]{aggregateType, idType, JMoleculesSpringJpaPlugin.getIdPrimitiveType(idType)}).build();
        DynamicType.Unloaded converterType = new ByteBuddy(ClassFileVersion.JAVA_V8).subclass((TypeDefinition)superType).defineConstructor(new ModifierContributor.ForMethod[]{Visibility.PACKAGE_PRIVATE}).intercept((Implementation)MethodCall.invoke(JMoleculesSpringJpaPlugin.getConverterConstructor()).onSuper().with(new TypeDescription[]{idType.asErasure()})).make();
        builder = builder.require(new DynamicType[]{converterType});
        log.info("jMolecules Spring JPA - {}.{} - Adding @j.p.Convert(converter={}).", new Object[]{PluginUtils.abbreviate((TypeDefinition)field.getDeclaringType()), field.getName(), PluginUtils.abbreviate((TypeDefinition)converterType.getTypeDescription())});
        return builder.field((ElementMatcher)ElementMatchers.is((FieldDescription.InDefinedShape)field)).annotateField(new AnnotationDescription[]{AnnotationDescription.Builder.ofType(Convert.class).define("converter", converterType.getTypeDescription()).build()});
    }

    private static TypeDescription.Generic getIdPrimitiveType(TypeDescription.Generic idType) {
        return ((FieldDescription.InGenericShape)idType.getDeclaredFields().get(0)).getType();
    }

    private static Constructor<?> getConverterConstructor() {
        try {
            return AssociationAttributeConverter.class.getDeclaredConstructor(Class.class);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

