/*
 * Decompiled with CFR 0.152.
 */
package org.jmolecules.hibernate;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Modifier;
import java.lang.reflect.RecordComponent;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import org.hibernate.Version;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.metamodel.spi.EmbeddableInstantiator;
import org.hibernate.metamodel.spi.ValueAccess;

public class RecordInstantiator
implements EmbeddableInstantiator {
    static final boolean IS_AFFECTED_HIBERNATE_VERSION = RecordInstantiator.isAffectedHibernateVersion();
    private final Class<?> type;
    private final List<Integer> indexes;
    private final Constructor<?> constructor;

    public RecordInstantiator(Class<?> type) {
        if (type == null) {
            throw new IllegalArgumentException("Record type must not be null!");
        }
        if (!type.isRecord()) {
            throw new IllegalArgumentException("Type must be a record!");
        }
        List<RecordComponent> components = Arrays.asList(type.getRecordComponents());
        Class[] parameterTypes = (Class[])components.stream().map(RecordComponent::getType).toArray(Class[]::new);
        this.type = type;
        this.constructor = RecordInstantiator.detectRecordConstructor(type, parameterTypes);
        this.indexes = RecordInstantiator.calculateIndexes(components);
    }

    public boolean isInstance(Object object, SessionFactoryImplementor sessionFactory) {
        return this.type.isInstance(object);
    }

    public boolean isSameClass(Object object, SessionFactoryImplementor sessionFactory) {
        return this.type.equals(object.getClass());
    }

    public Object instantiate(ValueAccess access, SessionFactoryImplementor factory) {
        Object[] sources = access.getValues();
        Object[] parameters = IS_AFFECTED_HIBERNATE_VERSION ? sources : this.indexes.stream().map(it -> sources[it]).toArray();
        try {
            return this.constructor.newInstance(parameters);
        }
        catch (IllegalAccessException | InstantiationException | InvocationTargetException o_O) {
            throw new RuntimeException(o_O);
        }
    }

    private static Constructor<?> detectRecordConstructor(Class<?> type, Class<?> ... parameterTypes) {
        try {
            return RecordInstantiator.makeAccessible(type.getDeclaredConstructor(parameterTypes));
        }
        catch (NoSuchMethodException | SecurityException e) {
            String message = String.format("Could not find record constructor on %s!", type.getClass());
            throw new IllegalArgumentException(message, e);
        }
    }

    private static Constructor<?> makeAccessible(Constructor<?> constructor) {
        if (!(Modifier.isPublic(constructor.getModifiers()) && Modifier.isPublic(constructor.getDeclaringClass().getModifiers()) || constructor.isAccessible())) {
            constructor.setAccessible(true);
        }
        return constructor;
    }

    private static boolean isAffectedHibernateVersion() {
        String version = Version.getVersionString();
        String[] parts = version.split("\\.");
        if (!parts[0].equals("6")) {
            return false;
        }
        if (!parts[1].equals("2")) {
            return false;
        }
        return Integer.parseInt(parts[2]) < 2;
    }

    private static List<Integer> calculateIndexes(List<RecordComponent> components) {
        if (components.size() == 1) {
            return Collections.singletonList(0);
        }
        List sorted = components.stream().sorted(Comparator.comparing(RecordComponent::getName)).collect(Collectors.toList());
        return components.stream().map(sorted::indexOf).collect(Collectors.toList());
    }
}

