/*
 * Decompiled with CFR 0.152.
 */
package org.jnosql.artemis.document;

import java.util.Objects;
import java.util.function.Function;
import java.util.function.UnaryOperator;
import org.jnosql.artemis.document.DocumentEntityConverter;
import org.jnosql.artemis.document.DocumentEventPersistManager;
import org.jnosql.artemis.document.DocumentWorkflow;
import org.jnosql.diana.api.document.DocumentEntity;

public abstract class AbsctractDocumentWorkflow
implements DocumentWorkflow {
    protected abstract DocumentEventPersistManager getDocumentEventPersistManager();

    protected abstract DocumentEntityConverter getConverter();

    @Override
    public <T> T flow(T entity, UnaryOperator<DocumentEntity> action) {
        Function<T, T> flow = this.getFlow(entity, action);
        return flow.apply(entity);
    }

    private <T> Function<T, T> getFlow(T entity, UnaryOperator<DocumentEntity> action) {
        UnaryOperator validation = t -> Objects.requireNonNull(t, "entity is required");
        UnaryOperator firePreEntity = t -> {
            this.getDocumentEventPersistManager().firePreEntity(t);
            return t;
        };
        UnaryOperator firePreDocumentEntity = t -> {
            this.getDocumentEventPersistManager().firePreDocumentEntity(t);
            return t;
        };
        Function<Object, DocumentEntity> converterDocument = t -> this.getConverter().toDocument(t);
        UnaryOperator firePreDocument = t -> {
            this.getDocumentEventPersistManager().firePreDocument((DocumentEntity)t);
            return t;
        };
        UnaryOperator firePostDocument = t -> {
            this.getDocumentEventPersistManager().firePostDocument((DocumentEntity)t);
            return t;
        };
        Function<DocumentEntity, Object> converterEntity = t -> this.getConverter().toEntity(entity, (DocumentEntity)t);
        UnaryOperator firePostEntity = t -> {
            this.getDocumentEventPersistManager().firePostEntity(t);
            return t;
        };
        UnaryOperator firePostDocumentEntity = t -> {
            this.getDocumentEventPersistManager().firePostDocumentEntity(t);
            return t;
        };
        return validation.andThen(firePreEntity).andThen(firePreDocumentEntity).andThen(converterDocument).andThen(firePreDocument).andThen(action).andThen(firePostDocument).andThen(converterEntity).andThen(firePostEntity).andThen(firePostDocumentEntity);
    }
}

