/*
 * Decompiled with CFR 0.152.
 */
package org.jnosql.artemis.document;

import java.time.Duration;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.jnosql.artemis.Converters;
import org.jnosql.artemis.IdNotFoundException;
import org.jnosql.artemis.PreparedStatementAsync;
import org.jnosql.artemis.document.DocumentEntityConverter;
import org.jnosql.artemis.document.DocumentMapperObserver;
import org.jnosql.artemis.document.DocumentPreparedStatementAsync;
import org.jnosql.artemis.document.DocumentTemplateAsync;
import org.jnosql.artemis.reflection.ClassMapping;
import org.jnosql.artemis.reflection.ClassMappings;
import org.jnosql.artemis.reflection.FieldMapping;
import org.jnosql.artemis.util.ConverterUtil;
import org.jnosql.diana.api.document.DocumentCollectionManagerAsync;
import org.jnosql.diana.api.document.DocumentDeleteQuery;
import org.jnosql.diana.api.document.DocumentEntity;
import org.jnosql.diana.api.document.DocumentObserverParser;
import org.jnosql.diana.api.document.DocumentQuery;
import org.jnosql.diana.api.document.DocumentQueryParserAsync;
import org.jnosql.diana.api.document.query.DocumentQueryBuilder;

public abstract class AbstractDocumentTemplateAsync
implements DocumentTemplateAsync {
    private static final Consumer EMPTY = t -> {};
    private static final DocumentQueryParserAsync PARSER = DocumentQueryParserAsync.getParser();
    private DocumentObserverParser observer;

    protected abstract DocumentEntityConverter getConverter();

    protected abstract DocumentCollectionManagerAsync getManager();

    protected abstract ClassMappings getClassMappings();

    protected abstract Converters getConverters();

    private DocumentObserverParser getObserver() {
        if (Objects.isNull(this.observer)) {
            this.observer = new DocumentMapperObserver(this.getClassMappings());
        }
        return this.observer;
    }

    @Override
    public <T> void insert(T entity) {
        this.insert(entity, EMPTY);
    }

    @Override
    public <T> void insert(T entity, Duration ttl) {
        this.insert(entity, ttl, EMPTY);
    }

    @Override
    public <T> void insert(T entity, Consumer<T> callBack) {
        Objects.requireNonNull(entity, "entity is required");
        Objects.requireNonNull(callBack, "callBack is required");
        Consumer<DocumentEntity> dianaCallBack = c -> callBack.accept(this.getConverter().toEntity(entity.getClass(), (DocumentEntity)c));
        this.getManager().insert(this.getConverter().toDocument(entity), dianaCallBack);
    }

    @Override
    public <T> void insert(T entity, Duration ttl, Consumer<T> callBack) {
        Objects.requireNonNull(entity, "entity is required");
        Objects.requireNonNull(ttl, "ttl is required");
        Objects.requireNonNull(callBack, "callBack is required");
        Consumer<DocumentEntity> dianaCallBack = c -> callBack.accept(this.getConverter().toEntity(entity.getClass(), (DocumentEntity)c));
        this.getManager().insert(this.getConverter().toDocument(entity), ttl, dianaCallBack);
    }

    @Override
    public <T> void update(T entity) {
        Objects.requireNonNull(entity, "entity is required");
        this.update(entity, EMPTY);
    }

    @Override
    public <T> void update(T entity, Consumer<T> callBack) {
        Objects.requireNonNull(entity, "entity is required");
        Objects.requireNonNull(callBack, "callBack is required");
        Consumer<DocumentEntity> dianaCallBack = c -> callBack.accept(this.getConverter().toEntity(entity.getClass(), (DocumentEntity)c));
        this.getManager().update(this.getConverter().toDocument(entity), dianaCallBack);
    }

    @Override
    public void delete(DocumentDeleteQuery query) {
        Objects.requireNonNull(query, "query is required");
        this.getManager().delete(query);
    }

    @Override
    public void delete(DocumentDeleteQuery query, Consumer<Void> callback) {
        Objects.requireNonNull(query, "query is required");
        Objects.requireNonNull(callback, "callBack is required");
        this.getManager().delete(query, callback);
    }

    @Override
    public <T> void select(DocumentQuery query, Consumer<List<T>> callback) {
        Objects.requireNonNull(query, "query is required");
        Objects.requireNonNull(callback, "callBack is required");
        Consumer<List> dianaCallBack = d -> callback.accept(d.stream().map(this.getConverter()::toEntity).map(o -> o).collect(Collectors.toList()));
        this.getManager().select(query, dianaCallBack);
    }

    @Override
    public <T, ID> void find(Class<T> entityClass, ID id, Consumer<Optional<T>> callBack) {
        Objects.requireNonNull(entityClass, "entityClass is required");
        Objects.requireNonNull(id, "id is required");
        Objects.requireNonNull(callBack, "callBack is required");
        ClassMapping classMapping = this.getClassMappings().get(entityClass);
        FieldMapping idField = (FieldMapping)classMapping.getId().orElseThrow(() -> IdNotFoundException.newInstance((Class)entityClass));
        Object value = ConverterUtil.getValue(id, (ClassMapping)classMapping, (String)idField.getFieldName(), (Converters)this.getConverters());
        DocumentQuery query = DocumentQueryBuilder.select().from(classMapping.getName()).where(idField.getName()).eq(value).build();
        this.singleResult(query, callBack);
    }

    @Override
    public <T, ID> void delete(Class<T> entityClass, ID id, Consumer<Void> callBack) {
        Objects.requireNonNull(entityClass, "entityClass is required");
        Objects.requireNonNull(id, "id is required");
        Objects.requireNonNull(callBack, "callBack is required");
        DocumentDeleteQuery query = this.getDeleteQuery(entityClass, id);
        this.delete(query, callBack);
    }

    @Override
    public <T, ID> void delete(Class<T> entityClass, ID id) {
        Objects.requireNonNull(entityClass, "entityClass is required");
        Objects.requireNonNull(id, "id is required");
        DocumentDeleteQuery query = this.getDeleteQuery(entityClass, id);
        this.delete(query);
    }

    @Override
    public <T> void query(String query, Consumer<List<T>> callback) {
        Objects.requireNonNull(query, "query is required");
        Objects.requireNonNull(callback, "callback is required");
        Consumer<List> mapper = columnEntities -> callback.accept(columnEntities.stream().map(c -> this.getConverter().toEntity((DocumentEntity)c)).collect(Collectors.toList()));
        PARSER.query(query, this.getManager(), mapper, this.getObserver());
    }

    @Override
    public <T> void singleResult(String query, Consumer<Optional<T>> callback) {
        Objects.requireNonNull(query, "query is required");
        Objects.requireNonNull(callback, "callBack is required");
        Consumer<List> mapper = columnEntities -> {
            List entities = columnEntities.stream().map(c -> this.getConverter().toEntity((DocumentEntity)c)).collect(Collectors.toList());
            if (entities.isEmpty()) {
                callback.accept(Optional.empty());
            }
            if (entities.size() == 1) {
                callback.accept(Optional.ofNullable(this.getConverter().toEntity((DocumentEntity)columnEntities.get(0))));
            }
            throw new UnsupportedOperationException("This query does not return a unique result: " + query);
        };
        PARSER.query(query, this.getManager(), mapper, this.getObserver());
    }

    @Override
    public PreparedStatementAsync prepare(String query) {
        Objects.requireNonNull(query, "query is required");
        return new DocumentPreparedStatementAsync(PARSER.prepare(query, this.getManager(), this.getObserver()), this.getConverter());
    }

    @Override
    public void count(String documentCollection, Consumer<Long> callback) {
        this.getManager().count(documentCollection, callback);
    }

    @Override
    public <T> void count(Class<T> entityClass, Consumer<Long> callback) {
        Objects.requireNonNull(entityClass, "entityClass is required");
        Objects.requireNonNull(callback, "callback is required");
        ClassMapping classMapping = this.getClassMappings().get(entityClass);
        this.getManager().count(classMapping.getName(), callback);
    }

    private <T, ID> DocumentDeleteQuery getDeleteQuery(Class<T> entityClass, ID id) {
        ClassMapping classMapping = this.getClassMappings().get(entityClass);
        FieldMapping idField = (FieldMapping)classMapping.getId().orElseThrow(() -> IdNotFoundException.newInstance((Class)entityClass));
        Object value = ConverterUtil.getValue(id, (ClassMapping)classMapping, (String)idField.getFieldName(), (Converters)this.getConverters());
        return DocumentQueryBuilder.delete().from(classMapping.getName()).where(idField.getName()).eq(value).build();
    }
}

