/*
 * Decompiled with CFR 0.152.
 */
package org.jnosql.artemis.document.query;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import org.jnosql.artemis.DynamicQueryException;
import org.jnosql.artemis.PreparedStatementAsync;
import org.jnosql.artemis.Query;
import org.jnosql.artemis.RepositoryAsync;
import org.jnosql.artemis.document.DocumentTemplateAsync;
import org.jnosql.artemis.document.query.BaseDocumentRepository;
import org.jnosql.artemis.query.RepositoryType;
import org.jnosql.diana.api.document.DocumentDeleteQuery;
import org.jnosql.diana.api.document.DocumentQuery;

public abstract class AbstractDocumentRepositoryAsyncProxy<T>
extends BaseDocumentRepository
implements InvocationHandler {
    protected abstract RepositoryAsync getRepository();

    protected abstract DocumentTemplateAsync getTemplate();

    @Override
    public Object invoke(Object instance, Method method, Object[] args) throws Throwable {
        RepositoryType type = RepositoryType.of((Method)method);
        switch (type) {
            case DEFAULT: {
                return method.invoke((Object)this.getRepository(), args);
            }
            case FIND_BY: {
                DocumentQuery query = this.getQuery(method, args);
                return this.executeQuery(this.getCallBack(args), query);
            }
            case DELETE_BY: {
                DocumentDeleteQuery deleteQuery = this.getDeleteQuery(method, args);
                return this.executeDelete(args, deleteQuery);
            }
            case OBJECT_METHOD: {
                return method.invoke((Object)this, args);
            }
            case JNOSQL_QUERY: {
                return this.getJnosqlQuery(method, args);
            }
        }
        return Void.class;
    }

    private Object executeDelete(Object[] args, DocumentDeleteQuery query1) {
        Object callBack = this.getCallBack(args);
        if (Consumer.class.isInstance(callBack)) {
            this.getTemplate().delete(query1, (Consumer)Consumer.class.cast(callBack));
        } else {
            this.getTemplate().delete(query1);
        }
        return Void.class;
    }

    private Object getCallBack(Object[] args) {
        return args[args.length - 1];
    }

    private Object executeQuery(Object arg, DocumentQuery query) {
        if (!Consumer.class.isInstance(arg)) {
            throw new DynamicQueryException("On select async method you must put a java.util.function.Consumer as end parameter as callback");
        }
        this.getTemplate().select(query, (Consumer)Consumer.class.cast(arg));
        return Void.class;
    }

    private Object getJnosqlQuery(Method method, Object[] args) {
        String value = method.getAnnotation(Query.class).value();
        Map<String, Object> params = this.getParams(method, args);
        Consumer<List<T>> consumer = this.getConsumer(args);
        if (params.isEmpty()) {
            this.getTemplate().query(value, consumer);
        } else {
            PreparedStatementAsync prepare = this.getTemplate().prepare(value);
            params.forEach((arg_0, arg_1) -> ((PreparedStatementAsync)prepare).bind(arg_0, arg_1));
            prepare.getResultList(consumer);
        }
        return Void.class;
    }

    private Consumer<List<T>> getConsumer(Object[] args) {
        Object callBack = this.getCallback(args);
        Consumer consumer = callBack instanceof Consumer ? (Consumer)Consumer.class.cast(callBack) : l -> {};
        return consumer;
    }

    private Object getCallback(Object[] args) {
        if (args == null || args.length == 0) {
            return null;
        }
        return args[args.length - 1];
    }
}

