/*
 * Decompiled with CFR 0.152.
 */
package org.jnosql.artemis.document.query;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Map;
import org.jnosql.artemis.PreparedStatement;
import org.jnosql.artemis.Query;
import org.jnosql.artemis.Repository;
import org.jnosql.artemis.document.DocumentTemplate;
import org.jnosql.artemis.document.query.BaseDocumentRepository;
import org.jnosql.artemis.document.query.ReturnTypeConverterUtil;
import org.jnosql.artemis.query.RepositoryType;
import org.jnosql.diana.api.document.DocumentDeleteQuery;
import org.jnosql.diana.api.document.DocumentQuery;
import org.jnosql.diana.api.document.query.DocumentQueryBuilder;

public abstract class AbstractDocumentRepositoryProxy<T>
extends BaseDocumentRepository
implements InvocationHandler {
    protected abstract Repository getRepository();

    protected abstract DocumentTemplate getTemplate();

    @Override
    public Object invoke(Object instance, Method method, Object[] args) throws Throwable {
        RepositoryType type = RepositoryType.of((Method)method);
        Class typeClass = this.getClassMapping().getClassInstance();
        switch (type) {
            case DEFAULT: {
                return method.invoke((Object)this.getRepository(), args);
            }
            case FIND_BY: {
                DocumentQuery query = this.getQuery(method, args);
                return ReturnTypeConverterUtil.returnObject(query, this.getTemplate(), typeClass, method);
            }
            case FIND_ALL: {
                return ReturnTypeConverterUtil.returnObject(DocumentQueryBuilder.select().from(this.getClassMapping().getName()).build(), this.getTemplate(), typeClass, method);
            }
            case DELETE_BY: {
                DocumentDeleteQuery documentDeleteQuery = this.getDeleteQuery(method, args);
                this.getTemplate().delete(documentDeleteQuery);
                return null;
            }
            case OBJECT_METHOD: {
                return method.invoke((Object)this, args);
            }
            case JNOSQL_QUERY: {
                return this.getJnosqlQuery(method, args, typeClass);
            }
        }
        return Void.class;
    }

    private Object getJnosqlQuery(Method method, Object[] args, Class<?> typeClass) {
        List entities;
        String value = method.getAnnotation(Query.class).value();
        Map<String, Object> params = this.getParams(method, args);
        if (params.isEmpty()) {
            entities = this.getTemplate().query(value);
        } else {
            PreparedStatement prepare = this.getTemplate().prepare(value);
            params.forEach((arg_0, arg_1) -> ((PreparedStatement)prepare).bind(arg_0, arg_1));
            entities = prepare.getResultList();
        }
        return ReturnTypeConverterUtil.returnObject(entities, typeClass, method);
    }
}

