/*
 * Decompiled with CFR 0.152.
 */
package org.jnosql.artemis.document.query;

import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.jnosql.artemis.Converters;
import org.jnosql.artemis.reflection.ClassMapping;
import org.jnosql.artemis.util.ConverterUtil;
import org.jnosql.diana.api.document.Document;
import org.jnosql.diana.api.document.DocumentCondition;

abstract class AbstractMapperQuery {
    protected final String documentCollection;
    protected boolean negate;
    protected DocumentCondition condition;
    protected boolean and;
    protected String name;
    protected final ClassMapping mapping;
    protected final Converters converters;
    protected long start;
    protected long limit;

    AbstractMapperQuery(ClassMapping mapping, Converters converters) {
        this.mapping = mapping;
        this.converters = converters;
        this.documentCollection = mapping.getName();
    }

    protected void appendCondition(DocumentCondition newCondition) {
        if (this.negate) {
            newCondition = newCondition.negate();
        }
        this.condition = Objects.nonNull(this.condition) ? (this.and ? this.condition.and(newCondition) : this.condition.or(newCondition)) : newCondition;
        this.negate = false;
        this.name = null;
    }

    protected <T> void betweenImpl(T valueA, T valueB) {
        Objects.requireNonNull(valueA, "valueA is required");
        Objects.requireNonNull(valueB, "valueB is required");
        DocumentCondition newCondition = DocumentCondition.between((Document)Document.of((String)this.mapping.getColumnField(this.name), Arrays.asList(this.getValue(valueA), this.getValue(valueB))));
        this.appendCondition(newCondition);
    }

    protected <T> void inImpl(Iterable<T> values) {
        Objects.requireNonNull(values, "values is required");
        List convertedValues = StreamSupport.stream(values.spliterator(), false).map(this::getValue).collect(Collectors.toList());
        DocumentCondition newCondition = DocumentCondition.in((Document)Document.of((String)this.mapping.getColumnField(this.name), convertedValues));
        this.appendCondition(newCondition);
    }

    protected <T> void eqImpl(T value) {
        Objects.requireNonNull(value, "value is required");
        DocumentCondition newCondition = DocumentCondition.eq((Document)Document.of((String)this.mapping.getColumnField(this.name), (Object)this.getValue(value)));
        this.appendCondition(newCondition);
    }

    protected void likeImpl(String value) {
        Objects.requireNonNull(value, "value is required");
        DocumentCondition newCondition = DocumentCondition.like((Document)Document.of((String)this.mapping.getColumnField(this.name), (Object)this.getValue(value)));
        this.appendCondition(newCondition);
    }

    protected <T> void gteImpl(T value) {
        Objects.requireNonNull(value, "value is required");
        DocumentCondition newCondition = DocumentCondition.gte((Document)Document.of((String)this.mapping.getColumnField(this.name), (Object)this.getValue(value)));
        this.appendCondition(newCondition);
    }

    protected <T> void gtImpl(T value) {
        Objects.requireNonNull(value, "value is required");
        DocumentCondition newCondition = DocumentCondition.gt((Document)Document.of((String)this.mapping.getColumnField(this.name), (Object)this.getValue(value)));
        this.appendCondition(newCondition);
    }

    protected <T> void ltImpl(T value) {
        Objects.requireNonNull(value, "value is required");
        DocumentCondition newCondition = DocumentCondition.lt((Document)Document.of((String)this.mapping.getColumnField(this.name), (Object)this.getValue(value)));
        this.appendCondition(newCondition);
    }

    protected <T> void lteImpl(T value) {
        Objects.requireNonNull(value, "value is required");
        DocumentCondition newCondition = DocumentCondition.lte((Document)Document.of((String)this.mapping.getColumnField(this.name), (Object)this.getValue(value)));
        this.appendCondition(newCondition);
    }

    protected Object getValue(Object value) {
        return ConverterUtil.getValue((Object)value, (ClassMapping)this.mapping, (String)this.name, (Converters)this.converters);
    }
}

