/*
 * Decompiled with CFR 0.152.
 */
package org.jnosql.artemis.document.query;

import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.jnosql.aphrodite.antlr.method.DeleteMethodFactory;
import org.jnosql.aphrodite.antlr.method.SelectMethodFactory;
import org.jnosql.artemis.Converters;
import org.jnosql.artemis.Param;
import org.jnosql.artemis.document.query.RepositoryDocumentObserverParser;
import org.jnosql.artemis.reflection.ClassMapping;
import org.jnosql.artemis.util.ParamsBinder;
import org.jnosql.diana.api.document.DocumentDeleteQuery;
import org.jnosql.diana.api.document.DocumentObserverParser;
import org.jnosql.diana.api.document.DocumentQuery;
import org.jnosql.diana.api.document.query.DeleteQueryConverter;
import org.jnosql.diana.api.document.query.DocumentDeleteQueryParams;
import org.jnosql.diana.api.document.query.DocumentQueryParams;
import org.jnosql.diana.api.document.query.SelectQueryConverter;
import org.jnosql.query.DeleteQuery;
import org.jnosql.query.Params;
import org.jnosql.query.SelectQuery;

abstract class BaseDocumentRepository {
    private DocumentObserverParser parser;
    private ParamsBinder paramsBinder;

    BaseDocumentRepository() {
    }

    protected abstract Converters getConverters();

    protected abstract ClassMapping getClassMapping();

    protected DocumentQuery getQuery(Method method, Object[] args) {
        SelectMethodFactory selectMethodFactory = SelectMethodFactory.get();
        SelectQuery selectQuery = (SelectQuery)selectMethodFactory.apply((Object)method, (Object)this.getClassMapping().getName());
        SelectQueryConverter converter = SelectQueryConverter.get();
        DocumentQueryParams queryParams = (DocumentQueryParams)converter.apply((Object)selectQuery, (Object)this.getParser());
        DocumentQuery query = queryParams.getQuery();
        Params params = queryParams.getParams();
        ParamsBinder paramsBinder = this.getParamsBinder();
        paramsBinder.bind(params, args, method);
        return query;
    }

    protected DocumentDeleteQuery getDeleteQuery(Method method, Object[] args) {
        DeleteMethodFactory deleteMethodFactory = DeleteMethodFactory.get();
        DeleteQuery deleteQuery = (DeleteQuery)deleteMethodFactory.apply((Object)method, (Object)this.getClassMapping().getName());
        DeleteQueryConverter converter = DeleteQueryConverter.get();
        DocumentDeleteQueryParams queryParams = (DocumentDeleteQueryParams)converter.apply((Object)deleteQuery, (Object)this.getParser());
        DocumentDeleteQuery query = queryParams.getQuery();
        Params params = queryParams.getParams();
        ParamsBinder paramsBinder = this.getParamsBinder();
        paramsBinder.bind(params, args, method);
        return query;
    }

    protected DocumentObserverParser getParser() {
        if (this.parser == null) {
            this.parser = new RepositoryDocumentObserverParser(this.getClassMapping());
        }
        return this.parser;
    }

    protected ParamsBinder getParamsBinder() {
        if (Objects.isNull(this.paramsBinder)) {
            this.paramsBinder = new ParamsBinder(this.getClassMapping(), this.getConverters());
        }
        return this.paramsBinder;
    }

    protected Map<String, Object> getParams(Method method, Object[] args) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        Parameter[] parameters = method.getParameters();
        for (int index = 0; index < parameters.length; ++index) {
            Parameter parameter = parameters[index];
            Param param = parameter.getAnnotation(Param.class);
            if (!Objects.nonNull(param)) continue;
            params.put(param.value(), args[index]);
        }
        return params;
    }
}

