/*
 * Decompiled with CFR 0.152.
 */
package org.jnosql.artemis.document.query;

import java.util.Objects;
import java.util.function.Consumer;
import org.jnosql.artemis.Converters;
import org.jnosql.artemis.document.DocumentTemplate;
import org.jnosql.artemis.document.DocumentTemplateAsync;
import org.jnosql.artemis.document.query.AbstractMapperQuery;
import org.jnosql.artemis.document.query.ArtemisDocumentDeleteQuery;
import org.jnosql.artemis.document.query.DocumentMapperDeleteFrom;
import org.jnosql.artemis.document.query.DocumentMapperDeleteNameCondition;
import org.jnosql.artemis.document.query.DocumentMapperDeleteNotCondition;
import org.jnosql.artemis.document.query.DocumentMapperDeleteWhere;
import org.jnosql.artemis.reflection.ClassMapping;
import org.jnosql.diana.api.document.DocumentDeleteQuery;

class DefaultDocumentMapperDeleteBuilder
extends AbstractMapperQuery
implements DocumentMapperDeleteFrom,
DocumentMapperDeleteWhere,
DocumentMapperDeleteNameCondition,
DocumentMapperDeleteNotCondition {
    DefaultDocumentMapperDeleteBuilder(ClassMapping mapping, Converters converters) {
        super(mapping, converters);
    }

    @Override
    public DocumentMapperDeleteNameCondition where(String name) {
        Objects.requireNonNull(name, "name is required");
        this.name = name;
        return this;
    }

    @Override
    public DocumentMapperDeleteNameCondition and(String name) {
        Objects.requireNonNull(name, "name is required");
        this.name = name;
        this.and = true;
        return this;
    }

    @Override
    public DocumentMapperDeleteNameCondition or(String name) {
        Objects.requireNonNull(name, "name is required");
        this.name = name;
        this.and = false;
        return this;
    }

    @Override
    public DocumentMapperDeleteNotCondition not() {
        this.negate = true;
        return this;
    }

    @Override
    public <T> DocumentMapperDeleteWhere eq(T value) {
        this.eqImpl(value);
        return this;
    }

    @Override
    public DocumentMapperDeleteWhere like(String value) {
        this.likeImpl(value);
        return this;
    }

    @Override
    public <T> DocumentMapperDeleteWhere gt(T value) {
        this.gtImpl(value);
        return this;
    }

    @Override
    public <T> DocumentMapperDeleteWhere gte(T value) {
        this.gteImpl(value);
        return this;
    }

    @Override
    public <T> DocumentMapperDeleteWhere lt(T value) {
        this.ltImpl(value);
        return this;
    }

    @Override
    public <T> DocumentMapperDeleteWhere lte(T value) {
        this.lteImpl(value);
        return this;
    }

    @Override
    public <T> DocumentMapperDeleteWhere between(T valueA, T valueB) {
        this.betweenImpl(valueA, valueB);
        return this;
    }

    @Override
    public <T> DocumentMapperDeleteWhere in(Iterable<T> values) {
        this.inImpl(values);
        return this;
    }

    @Override
    public DocumentDeleteQuery build() {
        return new ArtemisDocumentDeleteQuery(this.documentCollection, this.condition);
    }

    @Override
    public void execute(DocumentTemplate template) {
        Objects.requireNonNull(template, "template is required");
        template.delete(this.build());
    }

    @Override
    public void execute(DocumentTemplateAsync template) {
        Objects.requireNonNull(template, "template is required");
        template.delete(this.build());
    }

    @Override
    public void execute(DocumentTemplateAsync template, Consumer<Void> callback) {
        Objects.requireNonNull(template, "template is required");
        Objects.requireNonNull(callback, "callback is required");
        template.delete(this.build(), callback);
    }
}

