/*
 * Decompiled with CFR 0.152.
 */
package org.jnosql.artemis.document.query;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import org.jnosql.artemis.Converters;
import org.jnosql.artemis.document.DocumentTemplate;
import org.jnosql.artemis.document.DocumentTemplateAsync;
import org.jnosql.artemis.document.query.AbstractMapperQuery;
import org.jnosql.artemis.document.query.ArtemisDocumentQuery;
import org.jnosql.artemis.document.query.DocumentMapperFrom;
import org.jnosql.artemis.document.query.DocumentMapperLimit;
import org.jnosql.artemis.document.query.DocumentMapperNameCondition;
import org.jnosql.artemis.document.query.DocumentMapperNameOrder;
import org.jnosql.artemis.document.query.DocumentMapperNotCondition;
import org.jnosql.artemis.document.query.DocumentMapperOrder;
import org.jnosql.artemis.document.query.DocumentMapperSkip;
import org.jnosql.artemis.document.query.DocumentMapperWhere;
import org.jnosql.artemis.reflection.ClassMapping;
import org.jnosql.diana.api.Sort;
import org.jnosql.diana.api.document.DocumentQuery;

class DefaultDocumentMapperSelectBuilder
extends AbstractMapperQuery
implements DocumentMapperFrom,
DocumentMapperLimit,
DocumentMapperSkip,
DocumentMapperOrder,
DocumentMapperNameCondition,
DocumentMapperNotCondition,
DocumentMapperNameOrder,
DocumentMapperWhere {
    private final List<Sort> sorts = new ArrayList<Sort>();

    DefaultDocumentMapperSelectBuilder(ClassMapping mapping, Converters converters) {
        super(mapping, converters);
    }

    @Override
    public DocumentMapperNameCondition and(String name) {
        Objects.requireNonNull(name, "name is required");
        this.name = name;
        this.and = true;
        return this;
    }

    @Override
    public DocumentMapperNameCondition or(String name) {
        Objects.requireNonNull(name, "name is required");
        this.name = name;
        this.and = false;
        return this;
    }

    @Override
    public DocumentMapperNameCondition where(String name) {
        Objects.requireNonNull(name, "name is required");
        this.name = name;
        return this;
    }

    @Override
    public DocumentMapperSkip skip(long start) {
        this.start = start;
        return this;
    }

    @Override
    public DocumentMapperLimit limit(long limit) {
        this.limit = limit;
        return this;
    }

    @Override
    public DocumentMapperOrder orderBy(String name) {
        Objects.requireNonNull(name, "name is required");
        this.name = name;
        return this;
    }

    @Override
    public DocumentMapperNotCondition not() {
        this.negate = true;
        return this;
    }

    @Override
    public <T> DocumentMapperWhere eq(T value) {
        this.eqImpl(value);
        return this;
    }

    @Override
    public DocumentMapperWhere like(String value) {
        this.likeImpl(value);
        return this;
    }

    @Override
    public <T> DocumentMapperWhere gt(T value) {
        this.gtImpl(value);
        return this;
    }

    @Override
    public <T> DocumentMapperWhere gte(T value) {
        this.gteImpl(value);
        return this;
    }

    @Override
    public <T> DocumentMapperWhere lt(T value) {
        this.ltImpl(value);
        return this;
    }

    @Override
    public <T> DocumentMapperWhere lte(T value) {
        this.lteImpl(value);
        return this;
    }

    @Override
    public <T> DocumentMapperWhere between(T valueA, T valueB) {
        this.betweenImpl(valueA, valueB);
        return this;
    }

    @Override
    public <T> DocumentMapperWhere in(Iterable<T> values) {
        this.inImpl(values);
        return this;
    }

    @Override
    public DocumentMapperNameOrder asc() {
        this.sorts.add(Sort.of((String)this.mapping.getColumnField(this.name), (Sort.SortType)Sort.SortType.ASC));
        return this;
    }

    @Override
    public DocumentMapperNameOrder desc() {
        this.sorts.add(Sort.of((String)this.mapping.getColumnField(this.name), (Sort.SortType)Sort.SortType.DESC));
        return this;
    }

    @Override
    public DocumentQuery build() {
        return new ArtemisDocumentQuery(this.sorts, this.limit, this.start, this.condition, this.documentCollection);
    }

    @Override
    public <T> List<T> execute(DocumentTemplate template) {
        Objects.requireNonNull(template, "template is required");
        return template.select(this.build());
    }

    @Override
    public <T> Optional<T> executeSingle(DocumentTemplate template) {
        Objects.requireNonNull(template, "template is required");
        return template.singleResult(this.build());
    }

    @Override
    public <T> void execute(DocumentTemplateAsync template, Consumer<List<T>> callback) {
        Objects.requireNonNull(template, "template is required");
        Objects.requireNonNull(callback, "callback is required");
        template.select(this.build(), callback);
    }

    @Override
    public <T> void executeSingle(DocumentTemplateAsync template, Consumer<Optional<T>> callback) {
        Objects.requireNonNull(template, "template is required");
        Objects.requireNonNull(callback, "callback is required");
        template.singleResult(this.build(), callback);
    }
}

