/*
 * Decompiled with CFR 0.152.
 */
package org.jnosql.artemis.document.query;

import java.util.Objects;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.inject.Instance;
import javax.inject.Inject;
import org.jnosql.artemis.Converters;
import org.jnosql.artemis.document.query.DefaultDocumentMapperDeleteBuilder;
import org.jnosql.artemis.document.query.DefaultDocumentMapperSelectBuilder;
import org.jnosql.artemis.document.query.DocumentMapperDeleteFrom;
import org.jnosql.artemis.document.query.DocumentMapperFrom;
import org.jnosql.artemis.document.query.DocumentQueryMapperBuilder;
import org.jnosql.artemis.reflection.ClassMapping;
import org.jnosql.artemis.reflection.ClassMappings;

@ApplicationScoped
class DefaultDocumentQueryMapperBuilder
implements DocumentQueryMapperBuilder {
    @Inject
    private Instance<ClassMappings> mappings;
    @Inject
    private Instance<Converters> converters;

    DefaultDocumentQueryMapperBuilder() {
    }

    @Override
    public <T> DocumentMapperFrom selectFrom(Class<T> entityClass) {
        Objects.requireNonNull(entityClass, "entity is required");
        ClassMapping mapping = ((ClassMappings)this.mappings.get()).get(entityClass);
        return new DefaultDocumentMapperSelectBuilder(mapping, (Converters)this.converters.get());
    }

    @Override
    public <T> DocumentMapperDeleteFrom deleteFrom(Class<T> entityClass) {
        Objects.requireNonNull(entityClass, "entity is required");
        ClassMapping mapping = ((ClassMappings)this.mappings.get()).get(entityClass);
        return new DefaultDocumentMapperDeleteBuilder(mapping, (Converters)this.converters.get());
    }
}

