/*
 * Decompiled with CFR 0.152.
 */
package org.jnosql.artemis.document.query;

import java.lang.annotation.Annotation;
import java.lang.reflect.Proxy;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.context.spi.Contextual;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.BeanManager;
import javax.enterprise.inject.spi.InjectionPoint;
import javax.enterprise.inject.spi.PassivationCapable;
import org.jnosql.artemis.Converters;
import org.jnosql.artemis.DatabaseQualifier;
import org.jnosql.artemis.DatabaseType;
import org.jnosql.artemis.RepositoryAsync;
import org.jnosql.artemis.document.DocumentTemplateAsync;
import org.jnosql.artemis.document.query.DocumentRepositoryAsyncProxy;
import org.jnosql.artemis.reflection.ClassMappings;
import org.jnosql.artemis.util.AnnotationLiteralUtil;

public class DocumentRepositoryAsyncBean
implements Bean<RepositoryAsync>,
PassivationCapable {
    private final Class type;
    private final BeanManager beanManager;
    private final Set<Type> types;
    private final String provider;
    private final Set<Annotation> qualifiers;

    public DocumentRepositoryAsyncBean(Class type, BeanManager beanManager, String provider) {
        this.type = type;
        this.beanManager = beanManager;
        this.types = Collections.singleton(type);
        this.provider = provider;
        if (provider.isEmpty()) {
            this.qualifiers = new HashSet<Annotation>();
            this.qualifiers.add((Annotation)DatabaseQualifier.ofDocument());
            this.qualifiers.add((Annotation)AnnotationLiteralUtil.DEFAULT_ANNOTATION);
        } else {
            this.qualifiers = Collections.singleton(DatabaseQualifier.ofDocument((String)provider));
        }
    }

    public Class<?> getBeanClass() {
        return this.type;
    }

    public Set<InjectionPoint> getInjectionPoints() {
        return Collections.emptySet();
    }

    public boolean isNullable() {
        return false;
    }

    public RepositoryAsync create(CreationalContext<RepositoryAsync> creationalContext) {
        ClassMappings classMappings = this.getInstance(ClassMappings.class);
        DocumentTemplateAsync repository = this.provider.isEmpty() ? this.getInstance(DocumentTemplateAsync.class) : this.getInstance(DocumentTemplateAsync.class, this.provider);
        Converters converters = this.getInstance(Converters.class);
        DocumentRepositoryAsyncProxy handler = new DocumentRepositoryAsyncProxy(repository, classMappings, this.type, converters);
        return (RepositoryAsync)Proxy.newProxyInstance(this.type.getClassLoader(), new Class[]{this.type}, handler);
    }

    private <T> T getInstance(Class<T> clazz) {
        Bean bean = (Bean)this.beanManager.getBeans(clazz, new Annotation[0]).iterator().next();
        CreationalContext ctx = this.beanManager.createCreationalContext((Contextual)bean);
        return (T)this.beanManager.getReference(bean, clazz, ctx);
    }

    private <T> T getInstance(Class<T> clazz, String name) {
        Bean bean = (Bean)this.beanManager.getBeans(clazz, new Annotation[]{DatabaseQualifier.ofDocument((String)name)}).iterator().next();
        CreationalContext ctx = this.beanManager.createCreationalContext((Contextual)bean);
        return (T)this.beanManager.getReference(bean, clazz, ctx);
    }

    public void destroy(RepositoryAsync instance, CreationalContext<RepositoryAsync> creationalContext) {
    }

    public Set<Type> getTypes() {
        return this.types;
    }

    public Set<Annotation> getQualifiers() {
        return this.qualifiers;
    }

    public Class<? extends Annotation> getScope() {
        return ApplicationScoped.class;
    }

    public String getName() {
        return null;
    }

    public Set<Class<? extends Annotation>> getStereotypes() {
        return Collections.emptySet();
    }

    public boolean isAlternative() {
        return false;
    }

    public String getId() {
        return this.type.getName() + "Async@" + DatabaseType.DOCUMENT + "-" + this.provider;
    }
}

