/*
 * Decompiled with CFR 0.152.
 */
package org.jnosql.artemis.document.query;

import java.lang.reflect.ParameterizedType;
import org.jnosql.artemis.Converters;
import org.jnosql.artemis.RepositoryAsync;
import org.jnosql.artemis.document.DocumentTemplateAsync;
import org.jnosql.artemis.document.query.AbstractDocumentRepositoryAsync;
import org.jnosql.artemis.document.query.AbstractDocumentRepositoryAsyncProxy;
import org.jnosql.artemis.reflection.ClassMapping;
import org.jnosql.artemis.reflection.ClassMappings;

class DocumentRepositoryAsyncProxy<T>
extends AbstractDocumentRepositoryAsyncProxy {
    private final DocumentTemplateAsync template;
    private final DocumentRepositoryAsync repository;
    private final ClassMapping classMapping;
    private final Converters converters;

    DocumentRepositoryAsyncProxy(DocumentTemplateAsync template, ClassMappings classMappings, Class<?> repositoryType, Converters converters) {
        this.template = template;
        Class typeClass = (Class)Class.class.cast(((ParameterizedType)ParameterizedType.class.cast(repositoryType.getGenericInterfaces()[0])).getActualTypeArguments()[0]);
        this.classMapping = classMappings.get(typeClass);
        this.repository = new DocumentRepositoryAsync(template, this.classMapping);
        this.converters = converters;
    }

    @Override
    protected RepositoryAsync getRepository() {
        return this.repository;
    }

    @Override
    protected DocumentTemplateAsync getTemplate() {
        return this.template;
    }

    @Override
    protected ClassMapping getClassMapping() {
        return this.classMapping;
    }

    @Override
    protected Converters getConverters() {
        return this.converters;
    }

    class DocumentRepositoryAsync
    extends AbstractDocumentRepositoryAsync
    implements RepositoryAsync {
        private final DocumentTemplateAsync template;
        private final ClassMapping classMapping;

        DocumentRepositoryAsync(DocumentTemplateAsync template, ClassMapping classMapping) {
            this.template = template;
            this.classMapping = classMapping;
        }

        @Override
        protected DocumentTemplateAsync getTemplate() {
            return this.template;
        }

        @Override
        protected ClassMapping getClassMapping() {
            return this.classMapping;
        }
    }
}

