/*
 * Decompiled with CFR 0.152.
 */
package org.jnosql.artemis.document.spi;

import java.lang.reflect.ParameterizedType;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.inject.Produces;
import javax.enterprise.inject.spi.InjectionPoint;
import javax.inject.Inject;
import org.jnosql.artemis.ConfigurationUnit;
import org.jnosql.artemis.Repository;
import org.jnosql.artemis.RepositoryAsync;
import org.jnosql.artemis.document.DocumentRepositoryAsyncProducer;
import org.jnosql.artemis.document.DocumentRepositoryAsyncSupplier;
import org.jnosql.artemis.document.DocumentRepositoryProducer;
import org.jnosql.artemis.document.DocumentRepositorySupplier;
import org.jnosql.artemis.document.DocumentTemplate;
import org.jnosql.artemis.document.DocumentTemplateAsync;
import org.jnosql.artemis.document.spi.TemplateConfigurationProducer;

@ApplicationScoped
class DocumentRepositoryConfigurationProducer {
    @Inject
    private DocumentRepositoryProducer producer;
    @Inject
    private DocumentRepositoryAsyncProducer producerAsync;
    @Inject
    private TemplateConfigurationProducer configurationProducer;

    DocumentRepositoryConfigurationProducer() {
    }

    @ConfigurationUnit
    @Produces
    public <K, V, R extends Repository<?, ?>, E extends Repository<K, V>> DocumentRepositorySupplier<R> get(InjectionPoint injectionPoint) {
        ParameterizedType type = (ParameterizedType)injectionPoint.getType();
        Class repository = (Class)type.getActualTypeArguments()[0];
        DocumentTemplate template = this.configurationProducer.get(injectionPoint);
        return () -> this.producer.get(repository, template);
    }

    @ConfigurationUnit
    @Produces
    public <K, V, R extends RepositoryAsync<?, ?>, E extends RepositoryAsync<K, V>> DocumentRepositoryAsyncSupplier<R> getAsync(InjectionPoint injectionPoint) {
        ParameterizedType type = (ParameterizedType)injectionPoint.getType();
        Class repository = (Class)type.getActualTypeArguments()[0];
        DocumentTemplateAsync template = this.configurationProducer.getAsync(injectionPoint);
        return () -> this.producerAsync.get(repository, template);
    }
}

