/*
 * Decompiled with CFR 0.152.
 */
package org.jnosql.artemis.document.spi;

import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.inject.Produces;
import javax.enterprise.inject.spi.Annotated;
import javax.enterprise.inject.spi.InjectionPoint;
import javax.inject.Inject;
import org.jnosql.artemis.ConfigurationException;
import org.jnosql.artemis.ConfigurationUnit;
import org.jnosql.artemis.document.spi.DocumentConfigurationProducer;
import org.jnosql.artemis.util.ConfigurationUnitUtils;
import org.jnosql.artemis.util.StringUtils;
import org.jnosql.diana.api.document.DocumentCollectionManager;
import org.jnosql.diana.api.document.DocumentCollectionManagerAsync;
import org.jnosql.diana.api.document.DocumentCollectionManagerAsyncFactory;
import org.jnosql.diana.api.document.DocumentCollectionManagerFactory;

@ApplicationScoped
class ManagerConfigurationProducer {
    @Inject
    private DocumentConfigurationProducer configurationProducer;

    ManagerConfigurationProducer() {
    }

    @ConfigurationUnit
    @Produces
    public DocumentCollectionManager get(InjectionPoint injectionPoint) {
        DocumentCollectionManagerFactory managerFactory = this.configurationProducer.get(injectionPoint);
        ConfigurationUnit annotation = ConfigurationUnitUtils.getConfigurationUnit((InjectionPoint)injectionPoint, (Annotated)injectionPoint.getAnnotated());
        String database = annotation.database();
        if (StringUtils.isBlank((CharSequence)database)) {
            throw new ConfigurationException("The field database at ConfigurationUnit annotation is required");
        }
        return managerFactory.get(database);
    }

    @ConfigurationUnit
    @Produces
    public DocumentCollectionManagerAsync getAsync(InjectionPoint injectionPoint) {
        DocumentCollectionManagerAsyncFactory managerFactory = this.configurationProducer.getAsync(injectionPoint);
        ConfigurationUnit annotation = ConfigurationUnitUtils.getConfigurationUnit((InjectionPoint)injectionPoint, (Annotated)injectionPoint.getAnnotated());
        String database = annotation.database();
        if (StringUtils.isBlank((CharSequence)database)) {
            throw new ConfigurationException("The field database at ConfigurationUnit annotation is required");
        }
        return managerFactory.getAsync(database);
    }
}

