/*
 * Decompiled with CFR 0.152.
 */
package org.jnosql.diana.api.key;

import java.time.Duration;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.jnosql.diana.api.Value;
import org.jnosql.diana.api.key.KeyValueEntity;
import org.jnosql.diana.api.key.KeyValuePreparedStatement;
import org.jnosql.diana.api.key.KeyValueQueryParser;

public interface BucketManager
extends AutoCloseable {
    public <K, V> void put(K var1, V var2);

    public <K> void put(KeyValueEntity<K> var1);

    public <K> void put(KeyValueEntity<K> var1, Duration var2);

    public <K> void put(Iterable<KeyValueEntity<K>> var1);

    public <K> void put(Iterable<KeyValueEntity<K>> var1, Duration var2);

    public <K> Optional<Value> get(K var1);

    public <K> Iterable<Value> get(Iterable<K> var1);

    public <K> void remove(K var1);

    public <K> void remove(Iterable<K> var1);

    default public List<Value> query(String query) {
        Objects.requireNonNull(query, "query is required");
        KeyValueQueryParser parser = KeyValueQueryParser.getParser();
        return parser.query(query, this);
    }

    default public KeyValuePreparedStatement prepare(String query) {
        Objects.requireNonNull(query, "query is required");
        KeyValueQueryParser parser = KeyValueQueryParser.getParser();
        return parser.prepare(query, this);
    }

    @Override
    public void close();
}

