/*
 * Decompiled with CFR 0.152.
 */
package org.jnosql.diana.api.key;

import java.util.Objects;
import org.jnosql.diana.api.TypeSupplier;
import org.jnosql.diana.api.Value;
import org.jnosql.diana.api.key.KeyValueEntity;

final class DefaultKeyValueEntity<T>
implements KeyValueEntity {
    private final T key;
    private final Value value;

    DefaultKeyValueEntity(T key, Value value) {
        this.key = Objects.requireNonNull(key, "key is required");
        this.value = Objects.requireNonNull(value, "value is required");
    }

    @Override
    public T getKey() {
        return this.key;
    }

    public Object getKey(TypeSupplier typeSupplier) {
        return Value.of(this.key).get(typeSupplier);
    }

    public Object getKey(Class clazz) {
        return Value.of(this.key).get(clazz);
    }

    @Override
    public Value getValue() {
        return this.value;
    }

    @Override
    public Object get() {
        return this.value.get();
    }

    public Object get(TypeSupplier typeSupplier) {
        return this.value.get(typeSupplier);
    }

    public Object get(Class clazz) {
        return this.value.get(clazz);
    }

    public int hashCode() {
        return Objects.hash(this.key, this.value);
    }

    public String toString() {
        return "DefaultKeyValueEntity{key=" + this.key + ", value=" + this.value + '}';
    }
}

