/*
 * Decompiled with CFR 0.152.
 */
package org.jnosql.diana.api.key;

import java.util.List;
import java.util.Optional;
import java.util.ServiceLoader;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.jnosql.diana.api.key.KeyValueQueryParser;

final class KeyValueQueryParserServiceLoader {
    private static final List<KeyValueQueryParser> LOADERS;
    static final Optional<KeyValueQueryParser> INSTANCE;
    private static final String MESSAGE = "Could not found an implementation of KeyValueQueryParser in service loader.";

    private KeyValueQueryParserServiceLoader() {
    }

    static KeyValueQueryParser getInstance() {
        return INSTANCE.orElseThrow(() -> new IllegalStateException(MESSAGE));
    }

    static {
        ServiceLoader<KeyValueQueryParser> serviceLoader = ServiceLoader.load(KeyValueQueryParser.class);
        LOADERS = StreamSupport.stream(serviceLoader.spliterator(), false).collect(Collectors.toList());
        INSTANCE = LOADERS.stream().findFirst();
    }
}

