/*
 * Decompiled with CFR 0.152.
 */
package org.jnosql.diana.api.key.query;

import java.util.List;
import java.util.Objects;
import org.jnosql.diana.api.QueryException;
import org.jnosql.diana.api.Value;
import org.jnosql.diana.api.key.BucketManager;
import org.jnosql.diana.api.key.KeyValuePreparedStatement;
import org.jnosql.diana.api.key.KeyValueQueryParser;
import org.jnosql.diana.api.key.query.GetQueryParser;
import org.jnosql.diana.api.key.query.PutQueryParser;
import org.jnosql.diana.api.key.query.RemoveQueryParser;

public class DefaultKeyValueQueryParser
implements KeyValueQueryParser {
    private final PutQueryParser putQueryParser = new PutQueryParser();
    private final GetQueryParser getQueryParser = new GetQueryParser();
    private final RemoveQueryParser removeQueryParser = new RemoveQueryParser();

    @Override
    public List<Value> query(String query, BucketManager manager) {
        String command;
        this.validation(query, manager);
        switch (command = query.substring(0, 3)) {
            case "get": {
                return this.getQueryParser.query(query, manager);
            }
            case "rem": {
                return this.removeQueryParser.query(query, manager);
            }
            case "put": {
                return this.putQueryParser.query(query, manager);
            }
        }
        throw new QueryException(String.format("The command was not recognized at the query %s ", query));
    }

    @Override
    public KeyValuePreparedStatement prepare(String query, BucketManager manager) {
        String command;
        this.validation(query, manager);
        switch (command = query.substring(0, 3)) {
            case "get": {
                return this.getQueryParser.prepare(query, manager);
            }
            case "rem": {
                return this.removeQueryParser.prepare(query, manager);
            }
            case "put": {
                return this.putQueryParser.prepare(query, manager);
            }
        }
        throw new QueryException(String.format("The command was not recognized at the query %s ", query));
    }

    private void validation(String query, BucketManager manager) {
        Objects.requireNonNull(query, "query is required");
        Objects.requireNonNull(manager, "manager is required");
        if (query.length() <= 4) {
            throw new QueryException(String.format("The query %s is invalid", query));
        }
    }
}

