/*
 * Decompiled with CFR 0.152.
 */
package org.jnosql.diana.api.key.query;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.jnosql.diana.api.Params;
import org.jnosql.diana.api.QueryException;
import org.jnosql.diana.api.Value;
import org.jnosql.diana.api.key.BucketManager;
import org.jnosql.diana.api.key.KeyValuePreparedStatement;
import org.jnosql.diana.api.key.query.DefaultKeyValuePreparedStatement;
import org.jnosql.diana.api.key.query.Values;
import org.jnosql.query.GetQuery;
import org.jnosql.query.GetQuerySupplier;

final class GetQueryParser {
    private final GetQuerySupplier supplier = GetQuerySupplier.getSupplier();

    GetQueryParser() {
    }

    List<Value> query(String query, BucketManager manager) {
        GetQuery getQuery = (GetQuery)this.supplier.apply((Object)query);
        Params params = new Params();
        List values = getQuery.getKeys().stream().map(k -> Values.getValue(k, params)).collect(Collectors.toList());
        if (params.isNotEmpty()) {
            throw new QueryException("To run a query with a parameter use a PrepareStatement instead.");
        }
        List keys = values.stream().map(Value::get).collect(Collectors.toList());
        ArrayList<Value> result = new ArrayList<Value>();
        manager.get(keys).forEach(result::add);
        return result;
    }

    public KeyValuePreparedStatement prepare(String query, BucketManager manager) {
        GetQuery getQuery = (GetQuery)this.supplier.apply((Object)query);
        Params params = new Params();
        List<Value> values = getQuery.getKeys().stream().map(k -> Values.getValue(k, params)).collect(Collectors.toList());
        return DefaultKeyValuePreparedStatement.get(values, manager, params, query);
    }
}

